<?php
namespace WPT\Recipe\Equipment;

use Carbon_Fields\Field;
use Carbon_Fields\Container;

/**
 * PostMetaFields.
 */
class PostMetaFields
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Register Post Meta Fields.
     */
    public function register_fields()
    {
        $container = Container::make('post_meta', __('Affiliate Information', 'food-recipes'))
            ->where('post_type', '=', 'wpt-food-equipments')
            ->add_fields($this->get_fields());
        return $container;
    }

    /**
     * Get Fields
     */
    public function get_fields()
    {
        $fields = [];

        $fields[] = Field::make('text', 'wpt_recipe_equipment_affliate_link', __('Affiliate Link', 'food-recipes'))
            ->set_help_text(__('Add the affiliate link, if any', 'food-recipes'));

        return $fields;
    }

}
