<?php

namespace WPT\Recipe\Divi;

/**
 * Modules.
 */
class Modules {
    protected $container;

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
    }

    public function visual_builder_enqueue_scripts() {
        // phpcs:ignore
        if ( isset( $_GET['et_fb'] ) and $_GET['et_fb'] == '1' ) {
        }
    }

    public function et_builder_ready() {
        new \WPT_Recipe_Divi_Modules\FoodRecipeTitleModule\FoodRecipeTitleModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeDescriptionModule\FoodRecipeDescriptionModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeImageModule\FoodRecipeImageModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipePrepTimeModule\FoodRecipePrepTimeModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeCookTimeModule\FoodRecipeCookTimeModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeTotalTimeModule\FoodRecipeTotalTimeModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeCuisineModule\FoodRecipeCuisineModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeCourseModule\FoodRecipeCourseModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeServingsModule\FoodRecipeServingsModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeIngredientModule\FoodRecipeIngredientModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeInstructionsModule\FoodRecipeInstructionsModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeNotesModule\FoodRecipeNotesModule($this->container);
        new \WPT_Recipe_Divi_Modules\FoodRecipeAuthorModule\FoodRecipeAuthorModule($this->container);
    }

    public function divi_extensions_init() {
        new \WPT_Recipe_Divi_Modules\FoodRecipeExtension($this->container);
    }

    public function recipe_post_select_field() {
        return [
            'label'       => esc_html__( 'Select Recipe Post Item', 'food-recipes' ),
            'type'        => 'select',
            'options'     => $this->container['recipes']->all_as_options(),
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__( 'Select a recipe post. Use "-- Use Current Recipe Post --" to select the current post', 'food-recipes' ),
            'default'     => 'recipe--1',
        ];
    }

    /**
     * Determine if the request is from visual builder
     */
    public function is_visual_builder_request() {
        // phpcs:ignore
        return wp_doing_ajax() && isset( $_POST['options'], $_POST['options']['current_page'], $_POST['options']['current_page']['id'] );
    }

    public function get_post_from_props( $props ) {
        $post_id = $this->get_post_id_from_props( $props );
        if ( $post_id == "-1" ) {
            // phpcs:ignore
            if ( wp_doing_ajax() && isset( $_POST['options'], $_POST['options']['current_page'], $_POST['options']['current_page']['id'] ) ) {
                // its ajax request - return post object from post params
                // phpcs:ignore
                $post_id = (int) $_POST['options']['current_page']['id'];
                if ( false === get_post_status( $post_id ) ) {
                    return false;
                } else {
                    return get_post( $post_id );
                }
            } else {
                // return current post object
                global $post;
                return $post;
            }
        }
        return get_post( $post_id );
    }

    public function get_post_id_from_props( $props ) {
        return str_replace( 'recipe-', '', $props['post_id'] );
    }

}
