<?php
/*
 * Foo Functions - General
 * A bunch of common and useful functions that don't fall into any specific category
 *
 * Author: Brad Vincent
 * Author URI: https://fooplugins.com
 * License: GPL2
*/

if ( !function_exists( 'foo_check_php_version' ) ) {

	/**
	 * Checks the version of PHP running on the server.
	 *
	 * @param string $plugin_title The title of the plugin that is doing the check.
	 * @param string $ver          The minimum required version
	 *
	 * @throws Exception if the version does not meet minimum requirements
	 */
	function foo_check_php_version($plugin_title, $ver) {
		$php_version = phpversion();
		if ( version_compare( $php_version, $ver ) < 0 ) {
			throw new Exception(sprintf(esc_html__('%s requires at least version %s of PHP. You are running an older version (%s). Please update!', 'foobox-image-lightbox'), esc_html($plugin_title), esc_html($ver), esc_html($php_version)));
		}
	}
}

if ( !function_exists( 'foo_check_wp_version' ) ) {

	/**
	 * Checks the version of WordPress running on the server.
	 *
	 * @param string $plugin_title The title of the plugin that is doing the check.
	 * @param string $ver          The minimum required version
	 *
	 * @throws Exception if the version does not meet minimum requirements
	 */
	function foo_check_wp_version($plugin_title, $ver) {
		global $wp_version;
		if ( version_compare( $wp_version, $ver ) < 0 ) {
			throw new Exception(sprintf(esc_html__('%s requires at least version %s of WordPress. You are running an older version (%s). Please update!', 'foobox-image-lightbox'), esc_html($plugin_title), esc_html($ver), esc_html($wp_version)));
		}
	}
}