<?php
/**
 * FOMO Notifications Installation, Upgrade and Uninstallation Class
 *
 * @package Fomo_Notifications
 * @author WP Zinc
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Runs installation routines when the Plugin is activated,
 * such as database table creation.
 *
 * Upgrade routines run depending on the existing and updated
 * Plugin version.
 *
 * @package Fomo_Notifications
 * @author WP Zinc
 */
class Fomo_Notifications_Install {

	/**
	 * Runs installation routines for first time users
	 *
	 * @since   1.0.0
	 */
	public function install() {

		// Bail if we already have at least one Notification Group.
		$notifications = new Fomo_Notifications_Notifications();
		if ( $notifications->get_count() > 0 ) {
			return;
		}

		// Create a new Notification Group.
		$notifications->create(
			'WooCommerce Order Notifications',
			array(
				'source' => 'woocommerce',
			)
		);

		unset( $notifications );

	}

}
