<?php
/**
 * FOMO Notifications WordPress Plugin
 *
 * @package FOMO_Notifications
 * @author WP Zinc
 *
 * @wordpress-plugin
 * Plugin Name: FOMO Notifications
 * Plugin URI: http://www.wpzinc.com/plugins/fomo-notifications
 * Version: 1.0.0
 * Author: WP Zinc
 * Author URI: http://www.wpzinc.com
 * Description: Display recent sales notifications to create FOMO (Fear of Missing Out) in WooCommerce
 * Requires Plugins: woocommerce
 * License:     GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: fomo-notifications
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bail if Plugin is already loaded.
if ( class_exists( 'Fomo_Notifications' ) ) {
	return;
}
if ( defined( 'FOMO_NOTIFICATIONS_PLUGIN_VERSION' ) ) {
	return;
}

// Define Plugin version and build date.
define( 'FOMO_NOTIFICATIONS_PLUGIN_VERSION', '1.0.0' );
define( 'FOMO_NOTIFICATIONS_PLUGIN_BUILD_DATE', '2025-02-06 18:00:00' );

// Define Plugin paths.
define( 'FOMO_NOTIFICATIONS_PLUGIN_FILE', plugin_basename( __FILE__ ) );
define( 'FOMO_NOTIFICATIONS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FOMO_NOTIFICATIONS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

// Traits.
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/traits/trait-fomo-notifications-admin-section.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/traits/trait-fomo-notifications-admin-section-fields.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/traits/trait-fomo-notifications-settings.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/traits/trait-fomo-notifications-source.php';

// Admin.
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/admin/class-fomo-notifications-admin-notification-ui.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/admin/class-fomo-notifications-admin-section-general.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/admin/class-fomo-notifications-admin-settings.php';

// Global.
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/global/class-fomo-notifications-install.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/global/class-fomo-notifications-notification-settings.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/global/class-fomo-notifications-notifications.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/global/class-fomo-notifications-output.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/global/class-fomo-notifications-plugin-settings.php';
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/global/class-fomo-notifications-post-type.php';

// Sources.
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/sources/class-fomo-notifications-source-woocommerce.php';

// Activation.
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/activation.php';

// Bootstrap.
require_once FOMO_NOTIFICATIONS_PLUGIN_PATH . 'includes/class-fomo-notifications.php';

// Load Activation functions.
register_activation_hook( __FILE__, 'fomo_notifications_activate' );
if ( version_compare( get_bloginfo( 'version' ), '5.1', '>=' ) ) {
	add_action( 'wp_insert_site', 'fomo_notifications_activate_new_site' );
} else {
	add_action( 'wpmu_new_blog', 'fomo_notifications_activate_new_site' );
}
add_action( 'activate_blog', 'fomo_notifications_activate_new_site' );

/**
 * Main function to return Plugin instance.
 *
 * @since   1.0.0
 */
function fomo_notifications() {

	return Fomo_Notifications::get_instance();

}

// Finally, initialize the Plugin.
fomo_notifications();
