<?php
namespace FlxWoo\Rest\Traits;

if (!defined('ABSPATH')) exit;

/**
 * Response formatting utilities for REST endpoints
 * Provides consistent error responses and price formatting
 */
trait ResponseFormatter {

  /**
   * Format price with WooCommerce formatting and decode HTML entities
   *
   * @param float $amount The amount to format
   * @return string Formatted price without HTML tags
   */
  protected function format_price($amount) {
    return html_entity_decode(wp_strip_all_tags(wc_price($amount)), ENT_QUOTES | ENT_HTML5, 'UTF-8');
  }

  /**
   * Create standardized error response
   *
   * @param string $error Error category/title (should already be translated)
   * @param string $message Detailed error message (should already be translated)
   * @param int $status_code HTTP status code
   * @param array $extra_data Additional data to include in response
   * @return \WP_REST_Response
   */
  protected function error_response($error, $message, $status_code, $extra_data = []) {
    $response_data = array_merge([
      'error' => $error,
      'message' => $message
    ], $extra_data);

    return new \WP_REST_Response($response_data, $status_code);
  }
}
