<?php
namespace FlxWoo\Rest;

if (!defined('ABSPATH')) exit;

use FlxWoo\Rest\Endpoints\SiteEndpoints;

/**
 * REST API endpoint router
 * Delegates to specialized endpoint classes
 *
 * This class acts as a router that registers REST routes and delegates
 * to specialized endpoint classes for handling different types of requests.
 */
class RestEndpoints {

  /**
   * Endpoint instances
   */
  private $site_endpoints;

  /**
   * Constructor - Initialize endpoint instances
   */
  public function __construct() {
    $this->site_endpoints = new SiteEndpoints();
  }

  /**
   * Register REST API routes
   */
  public function register_routes() {
    // Site information endpoint
    register_rest_route(FLX_WOO_REST_NAMESPACE, '/' . FLX_WOO_REST_VERSION . '/site-info', [
      'methods' => 'GET',
      'callback' => [$this, 'get_site_info'],
      'permission_callback' => '__return_true', // Public endpoint
      'args' => [], // Explicitly declare no arguments accepted
    ]);
  }

  /**
   * Get site information
   * Delegates to SiteEndpoints
   *
   * @param \WP_REST_Request $request REST request object
   * @return \WP_REST_Response REST response
   */
  public function get_site_info(\WP_REST_Request $request) {
    return $this->site_endpoints->get_site_info($request);
  }
}
