<?php
namespace FlxWoo\Data\Traits;

if (!defined('ABSPATH')) exit;

/**
 * WooCommerce validation utilities
 * Provides consistent WooCommerce availability checks
 *
 * @since 2.0.0
 */
trait WooCommerceValidator {

  /**
   * Validate WooCommerce is active
   *
   * Checks if WooCommerce plugin is installed and activated
   * Used as a guard before accessing any WC() functions
   *
   * @return bool True if WooCommerce is active and available
   * @since 2.0.0
   */
  protected function is_woocommerce_active() {
    return function_exists('WC');
  }
}
