<?php
namespace FlxWoo\Data\Traits;

if (!defined('ABSPATH')) exit;

/**
 * Product image utilities
 * Provides responsive image data extraction for product images
 *
 * @since 2.0.0
 */
trait ImageHelper {

  /**
   * Get image size for product thumbnails
   *
   * @return string Image size identifier
   * @since 2.0.0
   */
  protected function get_image_size() {
    return 'thumbnail';
  }

  /**
   * Get product image data with responsive attributes
   *
   * Retrieves image URL, srcset, sizes, and alt text for responsive images
   * Returns null if image ID is invalid or image doesn't exist
   *
   * @param int $image_id WordPress attachment ID
   * @return array{url: string, srcset: string, sizes: string, alt: string}|null Image data or null if no image
   * @since 2.0.0
   */
  protected function get_product_image_data($image_id) {
    if (!$image_id) {
      return null;
    }

    $image_size = $this->get_image_size();
    $image_url = wp_get_attachment_image_url($image_id, $image_size);
    if (!$image_url) {
      return null;
    }

    return [
      'url' => $image_url,
      'srcset' => wp_get_attachment_image_srcset($image_id, $image_size) ?: '',
      'sizes' => wp_get_attachment_image_sizes($image_id, $image_size) ?: '',
      'alt' => get_post_meta($image_id, '_wp_attachment_image_alt', true) ?: '',
    ];
  }
}
