<?php
namespace FlxWoo\Data\Traits;

if (!defined('ABSPATH')) exit;

/**
 * Address data utilities
 * Provides consistent address extraction from WooCommerce objects
 *
 * @since 2.0.0
 */
trait AddressHelper {

  /**
   * Get address data from WooCommerce object
   *
   * Extracts billing or shipping address from WooCommerce customer or order objects
   * Handles both billing addresses (with email/phone) and shipping addresses (without)
   *
   * @param \WC_Customer|\WC_Order $object WooCommerce customer or order object
   * @param string $type Address type: 'billing' or 'shipping'
   * @return array{first_name: string, last_name: string, company: string, address_1: string, address_2: string, city: string, state: string, postcode: string, country: string, email: string, phone: string} Address data
   * @since 2.0.0
   */
  protected function get_address_data($object, $type) {
    $method_prefix = 'get_' . $type . '_';

    $address = [
      'first_name' => $object->{$method_prefix . 'first_name'}(),
      'last_name' => $object->{$method_prefix . 'last_name'}(),
      'company' => $object->{$method_prefix . 'company'}(),
      'address_1' => $object->{$method_prefix . 'address_1'}(),
      'address_2' => $object->{$method_prefix . 'address_2'}(),
      'city' => $object->{$method_prefix . 'city'}(),
      'state' => $object->{$method_prefix . 'state'}(),
      'postcode' => $object->{$method_prefix . 'postcode'}(),
      'country' => $object->{$method_prefix . 'country'}(),
    ];

    // Add email and phone for billing addresses
    if ($type === 'billing') {
      $address['email'] = $object->get_billing_email();
      $address['phone'] = $object->get_billing_phone();
    } else {
      // Shipping addresses don't have email/phone in WooCommerce
      $address['email'] = '';
      $address['phone'] = '';
    }

    return $address;
  }
}
