<?php
namespace FlxWoo\Constants;

if (!defined('ABSPATH')) exit;

/**
 * FlxWoo Configuration Constants
 *
 * These constants can be overridden in wp-config.php for custom deployments.
 * Example: define('FLX_WOO_RENDERER_URL', 'https://flx01.flxwoo.com');
 */

// =====================================
// Next.js Renderer Configuration (SaaS Model)
// =====================================
//
// IMPORTANT: FlxWoo operates as a SaaS model with:
// - One centralized Next.js renderer (flx) running on the SaaS provider's server
// - Multiple customer WooCommerce stores with flx-woo plugin installed
//
// These values are HARDCODED and NOT user-configurable for security and consistency.
// The SaaS provider manages the renderer infrastructure.
//
// For local development, override these in wp-config.php:
//   define('FLX_WOO_RENDERER_URL', 'http://localhost:3000');
//

// Next.js renderer URL - PRODUCTION SaaS ENDPOINT
// This should point to your centralized flx rendering service
// Override in wp-config.php for local development only
if (!defined('FLX_WOO_RENDERER_URL')) {
  define('FLX_WOO_RENDERER_URL', 'https://flx01.flxwoo.com');
}

// API version for rendering endpoints
// Maps to Next.js routes: /api/v1/{cart,checkout,thank-you}
// Fixed at v1, not user-configurable
if (!defined('FLX_WOO_RENDERER_VERSION')) {
  define('FLX_WOO_RENDERER_VERSION', 'v1');
}

// Timeout for renderer requests in seconds
// Production optimized: 5 seconds
// Not user-configurable to ensure consistent performance
if (!defined('FLX_WOO_RENDERER_TIMEOUT')) {
  define('FLX_WOO_RENDERER_TIMEOUT', 5);
}

// =====================================
// WordPress REST API Configuration
// =====================================

// WordPress REST API namespace
// Default: flx-woo
// Creates endpoints: /wp-json/flx-woo/v1/*
if (!defined('FLX_WOO_REST_NAMESPACE')) {
  define('FLX_WOO_REST_NAMESPACE', 'flx-woo');
}

// REST API version
// Default: v1
// Creates endpoints: /wp-json/flx-woo/v1/{site-info,checkout}
if (!defined('FLX_WOO_REST_VERSION')) {
  define('FLX_WOO_REST_VERSION', 'v1');
}

// =====================================
// Constants Class Wrapper
// =====================================

/**
 * Constants class
 *
 * Provides object-oriented access to plugin constants.
 */
class Constants {
	/**
	 * Plugin version
	 */
	const VERSION = '2.5.0';

	/**
	 * Get constant value
	 *
	 * @param string $name Constant name.
	 * @return mixed Constant value.
	 */
	public static function get( string $name ) {
		if ( defined( $name ) ) {
			return constant( $name );
		}
		return null;
	}
}
