<?php
/**
 * FlxWoo Settings Dashboard Template
 *
 * Simplified dashboard displaying plugin configuration settings.
 *
 * @package FlxWoo\Admin
 * @since 2.3.0 (Simplified from v2.2.0)
 *
 * @var PerformanceDashboard $this
 */

if (!defined('ABSPATH')) {
	exit;
}

// Get system status
$system_status = $this->get_system_status();

// Get analytics status (v2.3.0)
$analytics_status = $this->get_analytics_status();

// Get settings from SettingsManager
$settings_manager = new \FlxWoo\Admin\SettingsManager();
$user_settings = $settings_manager->get_all_settings();

// Ensure active_pages is always an array (handle null/empty from database)
$active_pages = $user_settings['active_pages'] ?? ['cart', 'checkout', 'thank-you'];
if (!is_array($active_pages)) {
	$active_pages = ['cart', 'checkout', 'thank-you'];
}

$settings = [
	'renderer_url' => defined('FLX_WOO_RENDERER_URL') ? FLX_WOO_RENDERER_URL : 'https://flx01.flxwoo.com',
	'timeout' => defined('FLX_WOO_RENDERER_TIMEOUT') ? FLX_WOO_RENDERER_TIMEOUT : 5,
	'fallback_enabled' => $user_settings['fallback_enabled'] ?? true,
	'active_pages' => $active_pages,
	'dev_mode' => $user_settings['dev_mode'] ?? false,
];

// Documentation URLs
$docs_base = 'https://flxwoo.com/docs';
$support_base = 'https://wordpress.org/support/plugin/flx-woo/';

?>

<div class="wrap flx-performance-dashboard">
	<h1><?php _e('Settings', 'flx-woo'); ?></h1>
	<p class="description"><?php _e('Configure FlxWoo rendering plugin settings.', 'flx-woo'); ?></p>

	<?php require __DIR__ . '/partials/performance/system-info.php'; ?>

	<?php require __DIR__ . '/partials/performance/configuration-form.php'; ?>

	<?php require __DIR__ . '/partials/performance/documentation.php'; ?>
</div>
