<?php
/**
 * Performance Dashboard: System Information
 *
 * Display system and renderer information.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $system_status System status information
 * @var array $settings Current settings
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- System Information -->
<div class="flx-dashboard-section flx-system-info">
	<h2>
		<span class="dashicons dashicons-info" style="color: #2271b1;"></span>
		<?php _e('System Information', 'flx-woo'); ?>
	</h2>
	<div class="flx-info-grid">
		<div class="flx-info-item">
			<strong><?php _e('Renderer Version:', 'flx-woo'); ?></strong>
			<span><?php echo esc_html($system_status['renderer_version']); ?></span>
		</div>
		<div class="flx-info-item">
			<strong><?php _e('Renderer URL:', 'flx-woo'); ?></strong>
			<span><?php echo esc_html($settings['renderer_url']); ?></span>
		</div>
		<div class="flx-info-item">
			<strong><?php _e('Request Timeout:', 'flx-woo'); ?></strong>
			<span><?php echo esc_html($settings['timeout']); ?>s</span>
		</div>
		<div class="flx-info-item">
			<strong><?php _e('Plugin Version:', 'flx-woo'); ?></strong>
			<span><?php echo esc_html($system_status['plugin_version']); ?></span>
		</div>
	</div>
</div>
