<?php
/**
 * Performance Dashboard: Documentation & Support
 *
 * Links to documentation and support resources.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var string $docs_base Documentation base URL
 * @var string $support_base Support base URL
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Documentation & Support -->
<div class="flx-dashboard-section flx-documentation">
	<h2>
		<span class="dashicons dashicons-book"></span>
		<?php _e('Documentation & Support', 'flx-woo'); ?>
	</h2>

	<div class="flx-doc-grid">
		<div class="flx-doc-item">
			<h3>
				<span class="dashicons dashicons-media-document"></span>
				<?php _e('Documentation', 'flx-woo'); ?>
			</h3>
			<p>
				<a href="<?php echo esc_url($docs_base); ?>" target="_blank">
					<?php _e('Getting Started Guide', 'flx-woo'); ?>
				</a>
			</p>
		</div>

		<div class="flx-doc-item">
			<h3>
				<span class="dashicons dashicons-sos"></span>
				<?php _e('Support', 'flx-woo'); ?>
			</h3>
			<p>
				<a href="<?php echo esc_url($support_base); ?>" target="_blank">
					<?php _e('Get Support', 'flx-woo'); ?>
				</a>
			</p>
		</div>
	</div>
</div>
