<?php
/**
 * Performance Dashboard: Configuration Form
 *
 * Settings form for FlxWoo configuration.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $settings Current settings
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Configuration Form -->
<div class="flx-dashboard-section flx-configuration">
	<h2>
		<span class="dashicons dashicons-admin-settings"></span>
		<?php _e('Configuration', 'flx-woo'); ?>
	</h2>

	<form id="flx-settings-form" method="post">
		<?php wp_nonce_field('flx_save_settings', 'flx_save_settings_nonce'); ?>

		<table class="form-table" role="presentation">
			<tbody>
				<!-- Fallback Mode -->
				<tr>
					<th scope="row">
						<label for="fallback_enabled"><?php _e('Fallback Mode', 'flx-woo'); ?></label>
					</th>
					<td>
						<label>
							<input
								type="checkbox"
								id="fallback_enabled"
								name="fallback_enabled"
								value="1"
								<?php checked($settings['fallback_enabled'], true); ?>
							/>
							<?php _e('Enable fallback to native WooCommerce if rendering fails', 'flx-woo'); ?>
						</label>
						<p class="description">
							<?php _e('Recommended: Keep enabled for production environments to ensure checkout never breaks.', 'flx-woo'); ?>
						</p>
					</td>
				</tr>

				<!-- Active Pages -->
				<tr>
					<th scope="row">
						<label><?php _e('Active Pages', 'flx-woo'); ?></label>
					</th>
					<td>
						<fieldset>
							<label>
								<input
									type="checkbox"
									name="active_pages[]"
									value="cart"
									<?php checked(in_array('cart', $settings['active_pages'])); ?>
								/>
								<?php _e('Cart Page', 'flx-woo'); ?>
							</label><br>

							<label>
								<input
									type="checkbox"
									name="active_pages[]"
									value="checkout"
									<?php checked(in_array('checkout', $settings['active_pages'])); ?>
								/>
								<?php _e('Checkout Page', 'flx-woo'); ?>
							</label><br>

							<label>
								<input
									type="checkbox"
									name="active_pages[]"
									value="thank-you"
									<?php checked(in_array('thank-you', $settings['active_pages'])); ?>
								/>
								<?php _e('Thank You Page', 'flx-woo'); ?>
							</label>
						</fieldset>
						<p class="description">
							<?php _e('Select which WooCommerce pages should use FlxWoo rendering.', 'flx-woo'); ?>
						</p>
					</td>
				</tr>

				<!-- Development Mode -->
				<tr>
					<th scope="row">
						<label for="dev_mode"><?php _e('Development Mode', 'flx-woo'); ?></label>
					</th>
					<td>
						<label>
							<input
								type="checkbox"
								id="dev_mode"
								name="dev_mode"
								value="1"
								<?php checked($settings['dev_mode'], true); ?>
							/>
							<?php _e('Enable development mode (allows HTTP for localhost)', 'flx-woo'); ?>
						</label>
						<p class="description">
							<?php _e('Only enable this for local development. Production should always use HTTPS.', 'flx-woo'); ?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>

		<p class="submit">
			<button type="submit" class="button button-primary" id="flx-save-settings">
				<?php _e('Save Settings', 'flx-woo'); ?>
			</button>
			<button type="button" class="button" id="flx-reset-settings">
				<?php _e('Reset to Defaults', 'flx-woo'); ?>
			</button>
		</p>

		<div id="flx-settings-message" class="notice" style="display: none; margin-top: 15px;">
			<p></p>
		</div>
	</form>
</div>
