<?php
/**
 * Store Information Section Partial
 *
 * Displays store ID, enabled features count, and rollout type.
 *
 * @package FlxWoo\Admin\Views\Partials
 * @version 2.4.0
 *
 * @var string $store_id Store hash ID
 * @var array $enabled_features Currently enabled feature names
 * @var array $flags Feature flag configurations
 */

if (!defined('ABSPATH')) {
	exit;
}

// Validate required variables
if (!isset($store_id) || !isset($enabled_features) || !isset($flags)) {
	return;
}
?>

<!-- Section 6: Store Information -->
<div class="flx-dashboard-section flx-store-info">
	<?php
	$section_title = 'Store Information';
	$section_icon = 'dashicons-info';
	$section_icon_color = '#2271b1';
	$section_description = '';
	include __DIR__ . '/../_shared/section-header.php';
	?>

	<div class="flx-info-grid">
		<!-- Store ID with network icon -->
		<div class="flx-info-item" style="border-left-color: #2271b1;">
			<strong>
				<span class="dashicons dashicons-admin-network"></span>
				<?php _e('Store ID (Hash):', 'flx-woo'); ?>
			</strong>
			<div class="flx-store-id-container">
				<code class="flx-store-id-display" data-full-id="<?php echo esc_attr($store_id); ?>">
					<?php echo esc_html(substr($store_id, 0, 16)); ?>...
				</code>
				<button type="button" class="button button-small flx-copy-store-id" title="<?php esc_attr_e('Copy full Store ID', 'flx-woo'); ?>">
					<?php _e('Copy', 'flx-woo'); ?>
				</button>
			</div>
		</div>

		<!-- Enabled Features with checkmark icon -->
		<div class="flx-info-item" style="border-left-color: #46b450;">
			<strong>
				<span class="dashicons dashicons-yes-alt"></span>
				<?php _e('Enabled Features:', 'flx-woo'); ?>
			</strong>
			<span style="font-size: 18px; font-weight: 600; color: #46b450; display: block; margin-top: 5px;">
				<?php echo esc_html(count($enabled_features)); ?> / <?php echo esc_html(count($flags)); ?>
			</span>
		</div>

		<!-- Rollout Type -->
		<div class="flx-info-item" style="border-left-color: #996800;">
			<strong>
				<span class="dashicons dashicons-backup"></span>
				<?php _e('Rollout Type:', 'flx-woo'); ?>
			</strong>
			<span style="display: block; margin-top: 5px;">
				<?php
				// Calculate rollout type based on enabled_globally flags
				$global_enabled = count(array_filter($flags, function($f) {
					return $f['enabled_globally'];
				}));
				if ($global_enabled === count($flags)) {
					echo __('All Global', 'flx-woo');
				} elseif ($global_enabled === 0) {
					echo __('Hash-based Only', 'flx-woo');
				} else {
					echo __('Mixed', 'flx-woo');
				}
				?>
			</span>
		</div>
	</div>

	<p class="description">
		<?php _e('The Store ID is an anonymous SHA-256 hash used for feature rollout. It cannot be reversed to determine your site URL.', 'flx-woo'); ?>
	</p>
</div>
