<?php
/**
 * Recent Activity Section Partial
 *
 * Displays recent feature flag changes with activity statistics and log table.
 *
 * @package FlxWoo\Admin\Views\Partials
 * @version 2.4.0
 *
 * @var array $recent_activity Recent activity log entries
 * @var array $activity_stats Activity statistics data
 * @var array $flags Feature flag configurations
 */

if (!defined('ABSPATH')) {
	exit;
}

// Validate required variables
if (!isset($recent_activity) || !isset($activity_stats) || !isset($flags)) {
	return;
}
?>

<!-- Section 4: Recent Activity -->
<div class="flx-dashboard-section flx-recent-activity">
	<?php
	$section_title = 'Recent Activity';
	$section_icon = 'dashicons-backup';
	$section_icon_color = '#2271b1';
	$section_description = 'View recent changes to feature flags for audit and debugging purposes.';
	include __DIR__ . '/../_shared/section-header.php';
	?>

	<!-- Activity Statistics -->
	<div class="flx-info-grid">
		<div class="flx-info-item" style="border-left-color: #2271b1;">
			<strong><?php _e('Total Changes', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; color: #2271b1; display: block; margin-top: 5px;">
				<?php echo esc_html($activity_stats['total_changes']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #46b450;">
			<strong><?php _e('Last 24 Hours', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; display: block; margin-top: 5px;">
				<?php echo esc_html($activity_stats['last_24h']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #996800;">
			<strong><?php _e('Most Active User', 'flx-woo'); ?></strong>
			<span style="display: block; margin-top: 5px;">
				<?php echo esc_html($activity_stats['most_active_user']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #d63638;">
			<strong><?php _e('Most Changed Flag', 'flx-woo'); ?></strong>
			<span style="display: block; margin-top: 5px;">
				<?php echo esc_html($activity_stats['most_changed_flag']); ?>
			</span>
		</div>
	</div>

	<!-- Activity Log Table -->
	<?php if (!empty($recent_activity)) : ?>
		<table class="flx-health-table" style="margin-top: 20px;">
			<thead>
				<tr>
					<th><?php _e('Timestamp', 'flx-woo'); ?></th>
					<th><?php _e('Feature', 'flx-woo'); ?></th>
					<th><?php _e('Action', 'flx-woo'); ?></th>
					<th><?php _e('Change', 'flx-woo'); ?></th>
					<th><?php _e('User', 'flx-woo'); ?></th>
					<th><?php _e('IP Address', 'flx-woo'); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($recent_activity as $entry) : ?>
					<tr>
						<td style="white-space: nowrap;">
							<?php echo esc_html(date_i18n('Y-m-d H:i:s', $entry['timestamp'])); ?>
						</td>
						<td>
							<strong><?php echo esc_html($flags[$entry['flag_name']]['display_name'] ?? str_replace('_', ' ', ucwords($entry['flag_name'], '_'))); ?></strong>
						</td>
						<td>
							<?php
							$action_label = \FlxWoo\FeatureFlags\ActivityLogger::get_action_label($entry['action']);
							$action_color = '#2271b1';
							if (strpos($entry['action'], 'enabled') !== false) {
								$action_color = '#46b450';
							} elseif (strpos($entry['action'], 'disabled') !== false || strpos($entry['action'], 'kill_switch_on') !== false) {
								$action_color = '#d63638';
							} elseif (strpos($entry['action'], 'rollout_changed') !== false) {
								$action_color = '#996800';
							}
							?>
							<span class="flx-health-status" style="background-color: <?php echo esc_attr($action_color); ?>;">
								<?php echo esc_html($action_label); ?>
							</span>
						</td>
						<td>
							<?php
							// Display change details
							if (isset($entry['old_value']) && isset($entry['new_value'])) {
								if (is_bool($entry['old_value']) || is_bool($entry['new_value'])) {
									$old = $entry['old_value'] ? __('enabled', 'flx-woo') : __('disabled', 'flx-woo');
									$new = $entry['new_value'] ? __('enabled', 'flx-woo') : __('disabled', 'flx-woo');
									echo esc_html(sprintf(__('%s → %s', 'flx-woo'), $old, $new));
								} elseif (is_numeric($entry['old_value']) && is_numeric($entry['new_value'])) {
									echo esc_html(sprintf(__('%d%% → %d%%', 'flx-woo'), $entry['old_value'], $entry['new_value']));
								} else {
									echo esc_html(sprintf(__('%s → %s', 'flx-woo'), $entry['old_value'], $entry['new_value']));
								}
							} else {
								echo '—';
							}
							?>
						</td>
						<td>
							<?php echo esc_html($entry['user_login']); ?>
						</td>
						<td style="font-family: monospace; font-size: 12px;">
							<?php echo esc_html($entry['ip_address']); ?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	<?php else : ?>
		<p style="margin-top: 20px; padding: 15px; background: #f0f0f1; border-left: 4px solid #2271b1;">
			<?php _e('No activity recorded yet. Changes to feature flags will appear here.', 'flx-woo'); ?>
		</p>
	<?php endif; ?>
</div>
