<?php
/**
 * Feature Overview Dashboard Partial
 *
 * Displays feature flag statistics and status at a glance.
 *
 * @package FlxWoo\Admin\Views
 * @var array $overview Feature overview data
 * @var array $status_list Feature status list
 */

if (!defined('ABSPATH')) {
	exit;
}
?>

<!-- Section 1: Feature Overview Dashboard -->
<div class="flx-dashboard-section flx-feature-overview">
	<h2>
		<span class="dashicons dashicons-dashboard" style="color: #2271b1;"></span>
		<?php _e('Feature Overview Dashboard', 'flx-woo'); ?>
	</h2>
	<p class="description"><?php _e('At-a-glance view of all feature flag status and statistics.', 'flx-woo'); ?></p>

	<!-- Stats Grid -->
	<div class="flx-info-grid">
		<div class="flx-info-item" style="border-left-color: #46b450;">
			<strong><?php _e('Enabled Features', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; color: #46b450;">
				<?php echo esc_html($overview['enabled_count']); ?> / <?php echo esc_html($overview['total_features']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #dcdcde;">
			<strong><?php _e('Disabled Features', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600;">
				<?php echo esc_html($overview['disabled_count']); ?> / <?php echo esc_html($overview['total_features']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #996800;">
			<strong><?php _e('With Dependencies', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600;">
				<?php echo esc_html($overview['with_dependencies']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: <?php echo $overview['kill_switch_active'] ? '#d63638' : '#46b450'; ?>;">
			<strong><?php _e('Kill Switch Status', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; color: <?php echo $overview['kill_switch_active'] ? '#d63638' : '#46b450'; ?>;">
				<?php echo $overview['kill_switch_active'] ? __('Active', 'flx-woo') : __('Inactive', 'flx-woo'); ?>
				<?php echo $overview['kill_switch_active'] ? '⚠️' : '✓'; ?>
			</span>
		</div>
	</div>

	<!-- Feature Status List -->
	<div class="flx-feature-status-list">
		<?php foreach ($status_list as $item) : ?>
			<div class="flx-feature-status-item <?php echo $item['enabled'] ? 'enabled' : 'disabled'; ?>">
				<span><?php echo esc_html($item['name']); ?></span>
				<?php if ($item['has_dependencies']) : ?>
					<div class="flx-feature-status-dependencies">
						<?php _e('Depends on:', 'flx-woo'); ?> <?php echo esc_html(implode(', ', $item['dependency_names'])); ?>
					</div>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
	</div>
</div>
