<?php
/**
 * Feature Health & Dependencies Section Partial
 *
 * Displays dependency tree visualization and health status table.
 *
 * @package FlxWoo\Admin\Views\Partials
 * @version 2.4.0
 *
 * @var array $dependency_tree Dependency tree data
 * @var array $health Feature health status data
 * @var array $flags Feature flag configurations
 */

if (!defined('ABSPATH')) {
	exit;
}

// Validate required variables
if (!isset($dependency_tree) || !isset($health) || !isset($flags)) {
	return;
}
?>

<!-- Section 3: Feature Health & Dependencies -->
<div class="flx-dashboard-section flx-feature-health">
	<?php
	$section_title = 'Feature Health & Dependencies';
	$section_icon = 'dashicons-networking';
	$section_icon_color = '#46b450';
	$section_description = 'Visualize feature relationships and monitor health status.';
	include __DIR__ . '/../_shared/section-header.php';
	?>

	<!-- Dependency Tree Visualization -->
	<div class="flx-dependency-tree">
		<?php foreach ($dependency_tree as $root => $data) : ?>
			<div class="flx-dependency-tree-root flx-dependency-tree-item <?php echo $data['enabled'] ? 'enabled' : 'disabled'; ?>">
				<?php echo esc_html($data['display_name']); ?> (Foundation)
			</div>
			<?php if (!empty($data['children'])) : ?>
				<?php foreach ($data['children'] as $child => $child_data) : ?>
					<div class="flx-dependency-tree-child flx-dependency-tree-item <?php echo $child_data['enabled'] ? 'enabled' : 'disabled'; ?>">
						<?php echo esc_html($child_data['display_name']); ?>
					</div>
				<?php endforeach; ?>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>

	<!-- Health Status Table -->
	<table class="flx-health-table">
		<thead>
			<tr>
				<th><?php _e('Feature', 'flx-woo'); ?></th>
				<th><?php _e('Status', 'flx-woo'); ?></th>
				<th><?php _e('Issues', 'flx-woo'); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ($health as $feature => $status) : ?>
				<tr>
					<td><?php echo esc_html($status['display_name']); ?></td>
					<td>
						<span class="flx-health-status <?php echo esc_attr($status['status']); ?>">
							<?php echo esc_html($status['status_label']); ?>
						</span>
					</td>
					<td><?php echo esc_html(implode(', ', $status['issues'])); ?></td>
				</tr>
			<?php endforeach; ?>
		</tbody>
	</table>
</div>
