<?php
/**
 * Emergency Controls Section Partial
 *
 * Displays kill switch form for emergency feature disablement.
 *
 * @package FlxWoo\Admin\Views\Partials
 * @version 2.4.0
 *
 * @var bool $kill_switch_active Whether global kill switch is active
 */

if (!defined('ABSPATH')) {
	exit;
}

// Validate required variables
if (!isset($kill_switch_active)) {
	return;
}
?>

<!-- Section 5: Emergency Controls -->
<div class="flx-dashboard-section flx-kill-switch">
	<?php
	$section_title = 'Emergency Controls';
	$section_icon = 'dashicons-warning';
	$section_icon_color = '#d63638';
	$section_description = 'Use these controls only in emergency situations to instantly disable all features.';
	include __DIR__ . '/../_shared/section-header.php';
	?>

	<!-- Warning Box -->
	<div class="flx-emergency-warning">
		<strong><?php _e('⚠️ Warning:', 'flx-woo'); ?></strong>
		<?php _e('Activating the kill switch will immediately disable all features, including analytics tracking and benchmarking.', 'flx-woo'); ?>
	</div>

	<form method="post" id="flx-kill-switch-form">
		<?php wp_nonce_field('flx_woo_feature_flags_nonce'); ?>

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row">
						<label for="kill_switch"><?php _e('Global Kill Switch', 'flx-woo'); ?></label>
					</th>
					<td>
						<label>
							<input
								type="checkbox"
								id="kill_switch"
								name="kill_switch"
								value="1"
								<?php checked($kill_switch_active, true); ?>
							/>
							<?php _e('Disable all features (emergency use only)', 'flx-woo'); ?>
						</label>
						<p class="description">
							<?php _e('When enabled, all features below are disabled regardless of their individual settings. Use this for emergency rollback.', 'flx-woo'); ?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>

		<p class="submit">
			<button type="submit" name="flx_woo_save_feature_flags" class="button button-primary">
				<?php _e('Save Settings', 'flx-woo'); ?>
			</button>
		</p>
	</form>
</div>
