<?php
/**
 * Documentation & Help Section Partial
 *
 * Displays documentation links and support resources.
 *
 * @package FlxWoo\Admin\Views\Partials
 * @version 2.4.0
 *
 * @var string $docs_url Documentation URL
 * @var string $privacy_url Privacy policy URL
 */

if (!defined('ABSPATH')) {
	exit;
}

// Set defaults
$docs_url = $docs_url ?? 'https://flxwoo.com/docs/analytics';
$privacy_url = $privacy_url ?? 'https://flxwoo.com/privacy';
?>

<!-- Section 8: Documentation & Help -->
<div class="flx-dashboard-section flx-documentation">
	<h2>
		<span class="dashicons dashicons-book"></span>
		<?php _e('Documentation & Help', 'flx-woo'); ?>
	</h2>

	<div class="flx-doc-grid">
		<div class="flx-doc-item">
			<h3>
				<span class="dashicons dashicons-media-document"></span>
				<?php _e('Documentation', 'flx-woo'); ?>
			</h3>
			<p>
				<a href="<?php echo esc_url($docs_url); ?>" target="_blank">
					<?php _e('Feature Documentation', 'flx-woo'); ?>
				</a><br>
				<a href="<?php echo esc_url($privacy_url); ?>" target="_blank">
					<?php _e('Privacy Policy', 'flx-woo'); ?>
				</a>
			</p>
		</div>

		<div class="flx-doc-item">
			<h3>
				<span class="dashicons dashicons-sos"></span>
				<?php _e('Support', 'flx-woo'); ?>
			</h3>
			<p>
				<a href="https://wordpress.org/support/plugin/flx-woo/" target="_blank">
					<?php _e('Report an Issue', 'flx-woo'); ?>
				</a>
			</p>
		</div>
	</div>
</div>
