<?php
/**
 * Data Retention Policies Section Partial
 *
 * Displays retention statistics and settings for activity log data cleanup.
 *
 * @package FlxWoo\Admin\Views\Partials
 * @version 2.4.0
 *
 * @var array $retention_stats Retention statistics data
 * @var int $retention_period Retention period in days
 * @var int|false $next_cleanup Next cleanup timestamp
 * @var int $deletion_preview Number of records pending deletion
 */

if (!defined('ABSPATH')) {
	exit;
}

// Get retention data if not provided
if (!isset($retention_stats)) {
	$retention_stats = \FlxWoo\FeatureFlags\RetentionManager::get_statistics();
}
if (!isset($retention_period)) {
	$retention_period = \FlxWoo\FeatureFlags\RetentionManager::get_retention_period();
}
if (!isset($next_cleanup)) {
	$next_cleanup = \FlxWoo\FeatureFlags\RetentionManager::get_next_cleanup_time();
}
if (!isset($deletion_preview)) {
	$deletion_preview = \FlxWoo\FeatureFlags\RetentionManager::get_deletion_preview();
}
?>

<!-- Section 7: Data Retention Policies -->
<div class="flx-dashboard-section flx-retention-policies">
	<?php
	$section_title = 'Data Retention Policies';
	$section_icon = 'dashicons-calendar-alt';
	$section_icon_color = '#996800';
	$section_description = 'Manage how long activity log data is retained. Automated cleanup helps prevent database bloat.';
	include __DIR__ . '/../_shared/section-header.php';
	?>

	<!-- Current Statistics -->
	<div class="flx-info-grid" style="margin-bottom: 20px;">
		<div class="flx-info-item" style="border-left-color: #2271b1;">
			<strong><?php _e('Total Records', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; color: #2271b1; display: block; margin-top: 5px;">
				<?php echo esc_html(number_format_i18n($retention_stats['total_records'])); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #996800;">
			<strong><?php _e('Oldest Record', 'flx-woo'); ?></strong>
			<span style="display: block; margin-top: 5px;">
				<?php
				if ($retention_stats['oldest_date']) {
					echo esc_html(date_i18n('Y-m-d', strtotime($retention_stats['oldest_date'])));
				} else {
					_e('No records', 'flx-woo');
				}
				?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #46b450;">
			<strong><?php _e('Database Size', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; display: block; margin-top: 5px;">
				<?php echo esc_html(number_format_i18n($retention_stats['size_mb'], 2)); ?> MB
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: <?php echo $deletion_preview > 0 ? '#d63638' : '#46b450'; ?>;">
			<strong><?php _e('Records to Delete', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; color: <?php echo $deletion_preview > 0 ? '#d63638' : '#46b450'; ?>; display: block; margin-top: 5px;">
				<?php echo esc_html(number_format_i18n($deletion_preview)); ?>
			</span>
		</div>
	</div>

	<!-- Retention Settings Form -->
	<form method="post" id="flx-retention-settings-form">
		<?php wp_nonce_field('flx_woo_retention_settings'); ?>

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row">
						<label for="retention_period"><?php _e('Retention Period', 'flx-woo'); ?></label>
					</th>
					<td>
						<select name="retention_period" id="retention_period">
							<option value="30" <?php selected($retention_period, 30); ?>><?php _e('30 days', 'flx-woo'); ?></option>
							<option value="60" <?php selected($retention_period, 60); ?>><?php _e('60 days', 'flx-woo'); ?></option>
							<option value="90" <?php selected($retention_period, 90); ?>><?php _e('90 days (recommended)', 'flx-woo'); ?></option>
							<option value="180" <?php selected($retention_period, 180); ?>><?php _e('6 months', 'flx-woo'); ?></option>
							<option value="365" <?php selected($retention_period, 365); ?>><?php _e('1 year', 'flx-woo'); ?></option>
							<option value="0" <?php selected($retention_period, 0); ?>><?php _e('Never delete (manual only)', 'flx-woo'); ?></option>
						</select>
						<p class="description" style="margin-top: 10px;">
							<?php _e('Activity log entries older than this period will be automatically deleted. Set to "Never delete" to disable automatic cleanup.', 'flx-woo'); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<?php _e('Automated Cleanup', 'flx-woo'); ?>
					</th>
					<td>
						<?php if ($next_cleanup) : ?>
							<p>
								<span class="dashicons dashicons-clock" style="color: #46b450;"></span>
								<strong style="color: #46b450;"><?php _e('Scheduled', 'flx-woo'); ?></strong>
							</p>
							<p style="margin-top: 8px;">
								<?php
								printf(
									/* translators: %s: formatted date and time */
									__('Next cleanup: %s', 'flx-woo'),
									'<strong>' . esc_html(date_i18n('Y-m-d H:i:s', $next_cleanup)) . '</strong>'
								);
								?>
							</p>
						<?php else : ?>
							<p>
								<span class="dashicons dashicons-warning" style="color: #996800;"></span>
								<strong style="color: #996800;"><?php _e('Not Scheduled', 'flx-woo'); ?></strong>
							</p>
							<p style="margin-top: 8px;">
								<?php _e('Automated cleanup is not scheduled. Save settings to enable.', 'flx-woo'); ?>
							</p>
						<?php endif; ?>
						<p class="description" style="margin-top: 15px;">
							<?php _e('Automated cleanup runs daily at 3:00 AM server time.', 'flx-woo'); ?>
						</p>
					</td>
				</tr>

				<?php if ($deletion_preview > 0) : ?>
					<tr>
						<th scope="row"></th>
						<td>
							<div class="notice notice-warning inline">
								<p>
									<strong><?php _e('⚠️ Warning:', 'flx-woo'); ?></strong>
									<?php
									printf(
										/* translators: 1: number of records, 2: retention period in days */
										_n(
											'%1$d record is older than %2$d days and will be deleted on the next cleanup.',
											'%1$d records are older than %2$d days and will be deleted on the next cleanup.',
											$deletion_preview,
											'flx-woo'
										),
										$deletion_preview,
										$retention_period
									);
									?>
								</p>
							</div>
						</td>
					</tr>
				<?php endif; ?>
			</tbody>
		</table>

		<p class="submit">
			<button type="submit" name="flx_woo_save_retention" class="button button-primary">
				<?php _e('Save Retention Settings', 'flx-woo'); ?>
			</button>
			<button type="button" id="flx-manual-cleanup" class="button button-secondary" style="margin-left: 10px;">
				<?php _e('Run Manual Cleanup Now', 'flx-woo'); ?>
			</button>
		</p>
	</form>
</div>
