<?php
/**
 * Compatibility: Data Table
 *
 * Displays compatibility information for all active plugins.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $compatibility_data Array of plugin compatibility data
 */

use FlxWoo\Admin\CompatibilityPage;

if (!defined('ABSPATH')) {
	exit;
}

?>

<table class="wp-list-table widefat fixed striped">
	<thead>
		<tr>
			<th style="width: 50px;">Status</th>
			<th style="width: 250px;">Plugin Name</th>
			<th style="width: 120px;">Version</th>
			<th style="width: 100px;">Score</th>
			<th style="width: 150px;">Compatibility</th>
			<th style="width: 120px;">Tested Stores</th>
			<th style="width: 150px;">Last Tested</th>
		</tr>
	</thead>
	<tbody>
		<?php foreach ($compatibility_data as $item): ?>
			<?php
			$plugin = $item['plugin'];
			$compatibility = $item['compatibility'];
			$error = $item['error'];
			$has_data = !empty($compatibility) && !$error;
			?>
			<?php require __DIR__ . '/table-row.php'; ?>
		<?php endforeach; ?>
	</tbody>
</table>
