<?php
/**
 * Compatibility: Table Row
 *
 * Single plugin compatibility table row with expandable details.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $plugin Plugin information
 * @var array|null $compatibility Compatibility data
 * @var string|null $error Error message if any
 * @var bool $has_data Whether compatibility data exists
 */

use FlxWoo\Admin\CompatibilityPage;

if (!defined('ABSPATH')) {
	exit;
}

?>

<tr>
	<!-- Status Icon -->
	<td>
		<?php if ($has_data): ?>
			<?php echo CompatibilityPage::get_status_icon($compatibility['test_status'] ?? 'unknown'); ?>
		<?php else: ?>
			<?php echo CompatibilityPage::get_status_icon('unknown'); ?>
		<?php endif; ?>
	</td>

	<!-- Plugin Name -->
	<td>
		<strong><?php echo esc_html($plugin['name']); ?></strong>
		<br>
		<code style="font-size: 11px; color: #666;"><?php echo esc_html($plugin['slug']); ?></code>
	</td>

	<!-- Version -->
	<td>
		<?php echo esc_html($plugin['version']); ?>
	</td>

	<!-- Score -->
	<td>
		<?php if ($has_data): ?>
			<?php
			$score = $compatibility['compatibility_score'] ?? 0;
			$class = CompatibilityPage::get_score_color_class($score);
			?>
			<span class="compatibility-score <?php echo esc_attr($class); ?>" style="
				display: inline-block;
				padding: 4px 12px;
				border-radius: 12px;
				font-weight: 600;
				font-size: 14px;
			">
				<?php echo esc_html($score); ?>/100
			</span>
		<?php else: ?>
			<span style="color: #94a3b8;">—</span>
		<?php endif; ?>
	</td>

	<!-- Compatibility Badge -->
	<td>
		<?php if ($has_data): ?>
			<?php
			$score = $compatibility['compatibility_score'] ?? 0;
			echo esc_html(CompatibilityPage::get_score_badge($score));
			?>
		<?php else: ?>
			<span style="color: #94a3b8;">? Not Tested</span>
		<?php endif; ?>
	</td>

	<!-- Tested Stores -->
	<td>
		<?php if ($has_data): ?>
			<?php echo esc_html($compatibility['tested_stores_count'] ?? 0); ?> store<?php echo ($compatibility['tested_stores_count'] ?? 0) !== 1 ? 's' : ''; ?>
		<?php else: ?>
			<span style="color: #94a3b8;">—</span>
		<?php endif; ?>
	</td>

	<!-- Last Tested -->
	<td>
		<?php if ($has_data && !empty($compatibility['last_tested_at'])): ?>
			<?php
			$timestamp = $compatibility['last_tested_at'];
			$date = gmdate('Y-m-d', $timestamp);
			$time_ago = human_time_diff($timestamp, time()) . ' ago';
			?>
			<span title="<?php echo esc_attr($date); ?>">
				<?php echo esc_html($time_ago); ?>
			</span>
		<?php else: ?>
			<span style="color: #94a3b8;">—</span>
		<?php endif; ?>
	</td>
</tr>

<!-- Known Issues (Expandable) -->
<?php if ($has_data && !empty($compatibility['known_issues'])): ?>
	<tr class="compatibility-details" style="display: none;">
		<td colspan="7" style="background: #f9fafb; padding: 15px;">
			<h4 style="margin-top: 0;">Known Issues</h4>
			<ul style="margin: 10px 0; padding-left: 20px;">
				<?php foreach ($compatibility['known_issues'] as $issue): ?>
					<li><?php echo esc_html($issue); ?></li>
				<?php endforeach; ?>
			</ul>

			<?php if (!empty($compatibility['workarounds'])): ?>
				<h4>Workarounds</h4>
				<ul style="margin: 10px 0; padding-left: 20px;">
					<?php foreach ($compatibility['workarounds'] as $workaround): ?>
						<li><?php echo esc_html($workaround); ?></li>
					<?php endforeach; ?>
				</ul>
			<?php endif; ?>
		</td>
	</tr>
<?php endif; ?>
