<?php
/**
 * Compatibility: Page Styles
 *
 * CSS styles for compatibility page.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<style>
.flx-woo-compatibility-header {
	background: #fff;
	padding: 20px;
	border: 1px solid #ccd0d4;
	border-radius: 4px;
	margin-top: 20px;
}

.flx-woo-compatibility-content {
	background: #fff;
}

.compatibility-score {
	font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;
}

.compatibility-score.score-verified {
	background: #d1fae5;
	color: #065f46;
}

.compatibility-score.score-compatible {
	background: #ecfccb;
	color: #365314;
}

.compatibility-score.score-issues {
	background: #fef3c7;
	color: #78350f;
}

.compatibility-score.score-incompatible {
	background: #fee2e2;
	color: #991b1b;
}

.flx-woo-compatibility table th {
	font-weight: 600;
}

.flx-woo-compatibility-footer {
	background: #f9fafb;
	padding: 20px;
	border-radius: 4px;
}

.flx-woo-compatibility-footer h3 {
	margin-top: 0;
}

.flx-woo-compatibility-footer ul {
	list-style-type: disc;
	padding-left: 20px;
}

.flx-woo-compatibility-footer li {
	margin: 8px 0;
}
</style>
