<?php
/**
 * Compatibility: Page Scripts
 *
 * JavaScript for AJAX refresh functionality.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<script>
jQuery(document).ready(function($) {
	// Refresh compatibility data via AJAX
	$('#flx-woo-refresh-compatibility').on('click', function() {
		var $button = $(this);
		$button.prop('disabled', true).text('Refreshing...');

		$.ajax({
			url: ajaxurl,
			type: 'POST',
			data: {
				action: 'flx_woo_compatibility',
				compatibility_action: 'refresh_data',
				nonce: '<?php echo esc_js(wp_create_nonce('flx_woo_compatibility')); ?>'
			},
			success: function(response) {
				if (response.success) {
					location.reload();
				} else {
					alert('Error refreshing data: ' + (response.data.message || 'Unknown error'));
					$button.prop('disabled', false).html('<span class="dashicons dashicons-update"></span> Refresh Data');
				}
			},
			error: function() {
				alert('Error refreshing data');
				$button.prop('disabled', false).html('<span class="dashicons dashicons-update"></span> Refresh Data');
			}
		});
	});
});
</script>
