<?php
/**
 * Compatibility: Page Header
 *
 * Header with description and action buttons.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<div class="flx-woo-compatibility-header">
	<p class="description">
		View compatibility information for your installed plugins with FlxWoo.
		Submit a compatibility report to help improve the FlxWoo compatibility database.
	</p>

	<form method="post" style="display: inline-block; margin-top: 10px; vertical-align: top;">
		<?php wp_nonce_field('flx_woo_compatibility'); ?>
		<input type="hidden" name="flx_woo_compatibility_action" value="submit_report">
		<button type="submit" class="button button-primary">
			Submit Compatibility Report
		</button>
	</form>

	<button type="button" id="flx-woo-refresh-compatibility" class="button" style="display: inline-block; margin-top: 10px; margin-left: 10px; vertical-align: top;">
		Refresh Data
	</button>
</div>
