<?php
/**
 * Benchmarking: JavaScript Initialization
 *
 * Pass data to JavaScript for interactive features.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var int $current_period Currently selected period
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<script>
// Pass WordPress data to JavaScript
window.flxBenchmarkData = {
	ajaxurl: '<?php echo esc_js(admin_url('admin-ajax.php')); ?>',
	nonce: '<?php echo esc_js(wp_create_nonce('flx_benchmark_nonce')); ?>',
	currentPeriod: <?php echo esc_js($current_period); ?>
};
</script>
