<?php
/**
 * Benchmarking: Period Selector
 *
 * Time period selection tabs.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $period_options Available period options
 * @var int $current_period Currently selected period
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Period Selector -->
<div class="flx-period-selector">
	<?php foreach ($period_options as $period): ?>
		<button
			class="flx-period-tab <?php echo $current_period === $period ? 'active' : ''; ?>"
			data-period="<?php echo esc_attr($period); ?>"
		>
			<?php echo esc_html($period . ' Days'); ?>
		</button>
	<?php endforeach; ?>
</div>
