<?php
/**
 * Benchmarking: Overview Statistics
 *
 * Key performance metrics with percentile comparisons.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $overview_stats Overview statistics
 * @var array $comparison_data Comparison data
 * @var object $this BenchmarkingPage instance
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Overview Stats -->
<div class="flx-dashboard-section flx-benchmark-overview">
	<h2>
		<span class="dashicons dashicons-chart-line" style="color: #2271b1;"></span>
		<?php esc_html_e('Performance Overview', 'flx-woo'); ?>
	</h2>
	<p class="description">
		<?php esc_html_e('Key metrics for your store performance.', 'flx-woo'); ?>
	</p>

	<div class="flx-info-grid">
		<!-- Conversion Rate -->
		<div class="flx-info-item" style="border-left-color: <?php echo $comparison_data['conversion_rate']['better'] ? '#46b450' : '#d63638'; ?>;">
			<strong><?php esc_html_e('Conversion Rate:', 'flx-woo'); ?></strong>
			<span style="font-size: 24px; font-weight: 600; color: <?php echo $comparison_data['conversion_rate']['better'] ? '#46b450' : '#d63638'; ?>;">
				<?php echo esc_html($overview_stats['conversion_rate']); ?>
			</span>
			<span class="flx-percentile-badge flx-percentile-<?php echo $this->get_percentile_tier($comparison_data['conversion_rate']['percentile']); ?>">
				<?php printf(esc_html__('%dth Percentile', 'flx-woo'), $comparison_data['conversion_rate']['percentile']); ?>
			</span>
		</div>

		<!-- Cart Value -->
		<div class="flx-info-item" style="border-left-color: <?php echo $comparison_data['cart_value']['better'] ? '#46b450' : '#d63638'; ?>;">
			<strong><?php esc_html_e('Average Cart Value:', 'flx-woo'); ?></strong>
			<span style="font-size: 24px; font-weight: 600;">
				<?php echo esc_html($overview_stats['cart_value']); ?>
			</span>
			<span class="flx-percentile-badge flx-percentile-<?php echo $this->get_percentile_tier($comparison_data['cart_value']['percentile']); ?>">
				<?php printf(esc_html__('%dth Percentile', 'flx-woo'), $comparison_data['cart_value']['percentile']); ?>
			</span>
		</div>

		<!-- Page Load Time -->
		<div class="flx-info-item" style="border-left-color: <?php echo $comparison_data['page_load']['better'] ? '#46b450' : '#d63638'; ?>;">
			<strong><?php esc_html_e('Page Load Time:', 'flx-woo'); ?></strong>
			<span style="font-size: 24px; font-weight: 600;">
				<?php echo esc_html($overview_stats['page_load']); ?>
			</span>
			<span class="flx-percentile-badge flx-percentile-<?php echo $this->get_percentile_tier($comparison_data['page_load']['percentile']); ?>">
				<?php printf(esc_html__('%dth Percentile', 'flx-woo'), $comparison_data['page_load']['percentile']); ?>
			</span>
		</div>

		<!-- Total Revenue -->
		<div class="flx-info-item" style="border-left-color: #2271b1;">
			<strong><?php esc_html_e('Total Revenue:', 'flx-woo'); ?></strong>
			<span style="font-size: 24px; font-weight: 600; color: #2271b1;">
				<?php echo esc_html($overview_stats['total_revenue']); ?>
			</span>
			<span style="font-size: 12px; color: #646970;">
				<?php printf(esc_html__('%d completed checkouts', 'flx-woo'), $overview_stats['checkouts_completed']); ?>
			</span>
		</div>
	</div>
</div>
