<?php
/**
 * Benchmarking: Insights Panel
 *
 * AI-generated actionable insights.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $insights AI-generated insights
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Insights Panel -->
<?php if (!empty($insights)): ?>
	<div class="flx-dashboard-section flx-insights-panel">
		<h2>
			<span class="dashicons dashicons-lightbulb" style="color: #f0b849;"></span>
			<?php esc_html_e('Actionable Insights', 'flx-woo'); ?>
		</h2>
		<p class="description">
			<?php esc_html_e('AI-generated recommendations based on your performance.', 'flx-woo'); ?>
		</p>

		<div class="flx-insights-list">
			<?php foreach ($insights as $insight): ?>
				<div class="flx-insight-item">
					<span class="dashicons dashicons-arrow-right-alt" style="color: #2271b1;"></span>
					<p><?php echo esc_html($insight); ?></p>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>
