<?php
/**
 * Benchmarking: Help & Documentation
 *
 * Information about benchmarking and percentiles.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Help & Documentation -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-info"></span>
		<?php esc_html_e('About Benchmarking', 'flx-woo'); ?>
	</h2>
	<div class="flx-info-grid">
		<div class="flx-info-item">
			<strong><?php esc_html_e('How It Works:', 'flx-woo'); ?></strong>
			<p style="margin: 5px 0 0 0; font-size: 13px;">
				<?php esc_html_e('We compare your store metrics to anonymous data from thousands of WooCommerce stores using FlxWoo. All data is GDPR/CCPA compliant with no PII collected.', 'flx-woo'); ?>
			</p>
		</div>
		<div class="flx-info-item">
			<strong><?php esc_html_e('Percentile Explained:', 'flx-woo'); ?></strong>
			<p style="margin: 5px 0 0 0; font-size: 13px;">
				<?php esc_html_e('78th percentile means your store performs better than 78% of stores. Top 25% = 75th+ percentile, Bottom 25% = below 25th percentile.', 'flx-woo'); ?>
			</p>
		</div>
	</div>
</div>
