<?php
/**
 * Benchmarking: Comparison Charts
 *
 * Industry comparison visualization.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $comparison_data Comparison data for charts
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Comparison Charts -->
<div class="flx-dashboard-section flx-benchmark-charts">
	<h2>
		<span class="dashicons dashicons-chart-bar"></span>
		<?php esc_html_e('Industry Comparison', 'flx-woo'); ?>
	</h2>
	<p class="description">
		<?php esc_html_e('How your store compares to industry averages.', 'flx-woo'); ?>
	</p>

	<div class="flx-chart-container">
		<canvas id="flx-benchmark-chart" width="800" height="400"></canvas>
	</div>

	<!-- Comparison Data (hidden, for JavaScript) -->
	<script type="application/json" id="flx-comparison-data">
		<?php echo wp_json_encode($comparison_data); ?>
	</script>
</div>
