<?php
/**
 * Analytics: Overview Statistics
 *
 * Displays activity overview statistics cards.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $overview_stats Overview statistics data
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Overview Statistics -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-dashboard" style="color: #2271b1;"></span>
		<?php _e('Activity Overview', 'flx-woo'); ?>
	</h2>
	<p class="description"><?php _e('At-a-glance summary of feature flag activity.', 'flx-woo'); ?></p>

	<div class="flx-info-grid">
		<div class="flx-info-item" style="border-left-color: #2271b1;">
			<strong><?php _e('Total Changes', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; color: #2271b1; display: block; margin-top: 5px;">
				<?php echo esc_html($overview_stats['total_changes']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #46b450;">
			<strong><?php _e('Last 24 Hours', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; display: block; margin-top: 5px;">
				<?php echo esc_html($overview_stats['last_24h']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #f0b849;">
			<strong><?php _e('Last 7 Days', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; display: block; margin-top: 5px;">
				<?php echo esc_html($overview_stats['last_7d']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #8c8f94;">
			<strong><?php _e('Average per Day', 'flx-woo'); ?></strong>
			<span style="font-size: 18px; font-weight: 600; display: block; margin-top: 5px;">
				<?php echo esc_html($overview_stats['avg_per_day']); ?>
			</span>
		</div>
	</div>
</div>
