<?php
/**
 * Analytics: Migration Status Notice
 *
 * Displays warning when activity log database table is missing.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $migration_stats Migration status data
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Migration Status Notice -->
<div class="notice notice-warning" style="padding: 20px; margin: 20px 0; border-left-color: #f0b849;">
	<h2 style="margin-top: 0;">
		<span class="dashicons dashicons-database" style="color: #f0b849;"></span>
		<?php _e('Database Table Missing', 'flx-woo'); ?>
	</h2>

	<p style="font-size: 14px; margin: 15px 0;">
		<?php _e('The activity log database table has not been created yet. This usually happens when the plugin was updated from an earlier version without reactivating.', 'flx-woo'); ?>
	</p>

	<div style="background: #fff3cd; padding: 15px; border-radius: 4px; margin: 15px 0;">
		<h3 style="margin-top: 0; font-size: 14px;">
			<span class="dashicons dashicons-info"></span>
			<?php _e('Migration Status:', 'flx-woo'); ?>
		</h3>
		<ul style="margin: 10px 0 10px 20px; list-style: disc;">
			<li>
				<strong><?php _e('Table Status:', 'flx-woo'); ?></strong>
				<?php echo $migration_stats['table_exists'] ?
					'<span style="color: green;">✓ ' . __('Exists', 'flx-woo') . '</span>' :
					'<span style="color: red;">✗ ' . __('Missing', 'flx-woo') . '</span>'; ?>
			</li>
			<li>
				<strong><?php _e('Database Version:', 'flx-woo'); ?></strong>
				<?php echo esc_html($migration_stats['db_version']); ?>
			</li>
			<li>
				<strong><?php _e('Needs Migration:', 'flx-woo'); ?></strong>
				<?php echo $migration_stats['needs_migration'] ?
					'<span style="color: orange;">⚠ ' . __('Yes', 'flx-woo') . '</span>' :
					'<span style="color: green;">✓ ' . __('No', 'flx-woo') . '</span>'; ?>
			</li>
			<?php if (isset($migration_stats['options_row_count']) && $migration_stats['options_row_count'] > 0): ?>
			<li>
				<strong><?php _e('Data in Options Table:', 'flx-woo'); ?></strong>
				<?php echo esc_html($migration_stats['options_row_count']); ?> <?php _e('entries (ready to migrate)', 'flx-woo'); ?>
			</li>
			<?php endif; ?>
		</ul>
	</div>

	<div style="background: #e7f3ff; padding: 15px; border-radius: 4px; border-left: 4px solid #2271b1; margin: 15px 0;">
		<h3 style="margin-top: 0; font-size: 14px; color: #135e96;">
			<span class="dashicons dashicons-admin-tools"></span>
			<?php _e('How to Fix:', 'flx-woo'); ?>
		</h3>
		<ol style="margin: 10px 0 10px 20px;">
			<li>
				<strong><?php _e('Automatic Fix (Recommended):', 'flx-woo'); ?></strong>
				<?php _e('The plugin will automatically create the table on the next page load. Simply refresh this page or navigate to any other admin page.', 'flx-woo'); ?>
			</li>
			<li>
				<strong><?php _e('Manual Fix:', 'flx-woo'); ?></strong>
				<?php _e('Go to the Plugins page, deactivate FlxWoo, then reactivate it. This will trigger the table creation.', 'flx-woo'); ?>
			</li>
		</ol>
		<p style="margin: 15px 0 0 0;">
			<button type="button" class="button button-secondary" onclick="location.reload();">
				<span class="dashicons dashicons-update" style="vertical-align: middle;"></span>
				<?php _e('Refresh Page to Check Status', 'flx-woo'); ?>
			</button>
		</p>
	</div>
</div>
