<?php
/**
 * Analytics: Key Insights & Help
 *
 * Displays key insights and help documentation.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $overview_stats Overview statistics data
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Additional Insights -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-info" style="color: #2271b1;"></span>
		<?php _e('Key Insights', 'flx-woo'); ?>
	</h2>

	<div class="flx-info-grid">
		<div class="flx-info-item" style="border-left-color: #46b450;">
			<strong><?php _e('Most Active User', 'flx-woo'); ?></strong>
			<span style="display: block; margin-top: 5px;">
				<?php echo esc_html($overview_stats['most_active_user']); ?>
			</span>
		</div>

		<div class="flx-info-item" style="border-left-color: #2271b1;">
			<strong><?php _e('Most Changed Flag', 'flx-woo'); ?></strong>
			<span style="display: block; margin-top: 5px;">
				<?php
				$flag_data = \FlxWoo\FeatureFlags\FeatureManager::get_flag($overview_stats['most_changed_flag']);
				echo esc_html($flag_data['display_name'] ?? str_replace('_', ' ', ucwords($overview_stats['most_changed_flag'], '_')));
				?>
			</span>
		</div>
	</div>
</div>

<!-- Section: Help & Documentation -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-book"></span>
		<?php _e('About Activity Analytics', 'flx-woo'); ?>
	</h2>

	<p><?php _e('This dashboard provides insights into how feature flags are being managed over time. Use the charts to:', 'flx-woo'); ?></p>
	<ul style="margin-left: 20px; list-style: disc;">
		<li><?php _e('Monitor activity patterns and identify trends', 'flx-woo'); ?></li>
		<li><?php _e('Track which features are changing most frequently', 'flx-woo'); ?></li>
		<li><?php _e('See who is making the most changes', 'flx-woo'); ?></li>
		<li><?php _e('Understand the distribution of different action types', 'flx-woo'); ?></li>
	</ul>

	<p>
		<strong><?php _e('Note:', 'flx-woo'); ?></strong>
		<?php _e('All IP addresses are anonymized for GDPR compliance. Activity data is stored securely and can be managed via retention policies.', 'flx-woo'); ?>
	</p>
</div>
