<?php
/**
 * Analytics: Filters & Export Form
 *
 * Filter activity data by date, flags, actions, and users. Export to CSV.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Advanced Filters & Export -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-filter"></span>
		<?php _e('Filters & Export', 'flx-woo'); ?>
	</h2>
	<p class="description"><?php _e('Filter activity data and export to CSV.', 'flx-woo'); ?></p>

	<form method="post" id="flx-analytics-filters">
		<?php wp_nonce_field('flx_woo_analytics_filters'); ?>

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row">
						<label for="flx-date-range"><?php _e('Date Range', 'flx-woo'); ?></label>
					</th>
					<td>
						<select name="date_range" id="flx-date-range">
							<option value=""><?php _e('All time', 'flx-woo'); ?></option>
							<option value="7"><?php _e('Last 7 days', 'flx-woo'); ?></option>
							<option value="30" selected><?php _e('Last 30 days', 'flx-woo'); ?></option>
							<option value="90"><?php _e('Last 90 days', 'flx-woo'); ?></option>
						</select>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="flx-flag-names"><?php _e('Feature Flags', 'flx-woo'); ?></label>
					</th>
					<td>
						<select name="flag_names[]" id="flx-flag-names" multiple size="5">
							<?php
							$repo = new \FlxWoo\Database\ActivityRepository();
							$unique_flags = $repo->get_unique_flags();
							foreach ($unique_flags as $flag) {
								// Use proper display name from FeatureManager
								$flag_data = \FlxWoo\FeatureFlags\FeatureManager::get_flag($flag);
								$label = $flag_data['display_name'] ?? str_replace('_', ' ', ucwords($flag, '_'));
								echo '<option value="' . esc_attr($flag) . '">' . esc_html($label) . '</option>';
							}
							?>
						</select>
						<p class="description"><?php _e('Hold Ctrl/Cmd to select multiple', 'flx-woo'); ?></p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="flx-actions"><?php _e('Action Types', 'flx-woo'); ?></label>
					</th>
					<td>
						<select name="actions[]" id="flx-actions" multiple size="5">
							<?php
							$unique_actions = $repo->get_unique_actions();
							foreach ($unique_actions as $action) {
								$label = \FlxWoo\FeatureFlags\ActivityLogger::get_action_label($action);
								echo '<option value="' . esc_attr($action) . '">' . esc_html($label) . '</option>';
							}
							?>
						</select>
						<p class="description"><?php _e('Hold Ctrl/Cmd to select multiple', 'flx-woo'); ?></p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="flx-users"><?php _e('Users', 'flx-woo'); ?></label>
					</th>
					<td>
						<select name="user_id" id="flx-users">
							<option value=""><?php _e('All users', 'flx-woo'); ?></option>
							<?php
							$unique_users = $repo->get_unique_users();
							foreach ($unique_users as $user_data) {
								echo '<option value="' . esc_attr($user_data['user_id']) . '">' . esc_html($user_data['user_login']) . '</option>';
							}
							?>
						</select>
					</td>
				</tr>
			</tbody>
		</table>

		<p class="submit">
			<button type="submit" class="button button-primary">
				<?php _e('Apply Filters', 'flx-woo'); ?>
			</button>
			<button type="button" id="flx-clear-filters" class="button" style="margin-left: 10px;">
				<?php _e('Clear Filters', 'flx-woo'); ?>
			</button>
			<button type="button" id="flx-export-csv" class="button" style="margin-left: 10px;">
				<?php _e('Export CSV', 'flx-woo'); ?>
			</button>
		</p>
	</form>
</div>
