<?php
/**
 * Analytics: Empty State Notice
 *
 * Displays informational notice when no analytics data exists yet.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Empty State Notice -->
<div class="notice notice-info" style="padding: 20px; margin: 20px 0; border-left-color: #2271b1;">
	<h2 style="margin-top: 0;">
		<span class="dashicons dashicons-info" style="color: #2271b1;"></span>
		<?php _e('No Analytics Data Yet', 'flx-woo'); ?>
	</h2>

	<p style="font-size: 14px; margin: 15px 0;">
		<?php _e('Analytics data collection has not started yet. This is normal for new installations or when no feature flag changes have been made.', 'flx-woo'); ?>
	</p>

	<div style="background: #f8f9fa; padding: 15px; border-radius: 4px; margin: 15px 0;">
		<h3 style="margin-top: 0; font-size: 14px;">
			<?php _e('How Analytics Data Collection Works:', 'flx-woo'); ?>
		</h3>
		<ul style="margin: 10px 0 10px 20px; list-style: disc;">
			<li>
				<strong><?php _e('Real-Time Tracking:', 'flx-woo'); ?></strong>
				<?php _e('Every time you or your team changes a feature flag setting (enable, disable, update rollout percentage, etc.), FlxWoo automatically logs the activity.', 'flx-woo'); ?>
			</li>
			<li>
				<strong><?php _e('Immediate Visibility:', 'flx-woo'); ?></strong>
				<?php _e('Changes appear on this dashboard instantly—no waiting required!', 'flx-woo'); ?>
			</li>
			<li>
				<strong><?php _e('What Triggers Data Collection:', 'flx-woo'); ?></strong>
				<?php _e('Modifying feature flags in the Feature Flags page, API changes, or automated system updates.', 'flx-woo'); ?>
			</li>
		</ul>
	</div>

	<div style="background: #fff3cd; padding: 15px; border-radius: 4px; border-left: 4px solid #f0b849; margin: 15px 0;">
		<h3 style="margin-top: 0; font-size: 14px; color: #856404;">
			<span class="dashicons dashicons-lightbulb" style="color: #f0b849;"></span>
			<?php _e('Next Steps:', 'flx-woo'); ?>
		</h3>
		<ol style="margin: 10px 0 10px 20px;">
			<li>
				<strong><?php _e('Make Your First Change:', 'flx-woo'); ?></strong>
				<?php
				printf(
					/* translators: %s: URL to Feature Flags page */
					__('Go to <a href="%s">Feature Flags</a> and enable or modify any feature flag.', 'flx-woo'),
					esc_url(admin_url('admin.php?page=flx-woo-feature-flags'))
				);
				?>
			</li>
			<li>
				<strong><?php _e('Refresh This Page:', 'flx-woo'); ?></strong>
				<?php _e('After making changes, return here to see your analytics data populated with charts and insights.', 'flx-woo'); ?>
			</li>
			<li>
				<strong><?php _e('Monitor Activity:', 'flx-woo'); ?></strong>
				<?php _e('Use the charts below to track who is making changes, which flags are most active, and identify patterns over time.', 'flx-woo'); ?>
			</li>
		</ol>
	</div>

	<p style="margin-bottom: 0; color: #666; font-size: 13px;">
		<strong><?php _e('Note:', 'flx-woo'); ?></strong>
		<?php _e('This analytics dashboard tracks feature flag configuration changes only. For conversion analytics (checkout events, cart activity), please check the main dashboard or wait for the next scheduled data aggregation.', 'flx-woo'); ?>
	</p>
</div>
