<?php
/**
 * Analytics: Activity Timeline Chart
 *
 * Displays daily feature flag changes over time.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Activity Timeline -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-chart-line" style="color: #2271b1;"></span>
		<?php _e('Activity Timeline', 'flx-woo'); ?>
	</h2>
	<p class="description"><?php _e('Daily feature flag changes over time.', 'flx-woo'); ?></p>

	<div class="flx-chart-container">
		<div class="flx-chart-loading" id="flx-timeline-loading">
			<?php _e('Loading chart...', 'flx-woo'); ?>
		</div>
		<canvas id="flx-timeline-chart" style="display: none;"></canvas>
	</div>
</div>
