<?php
/**
 * Analytics: Breakdown Charts (Feature, User, Action)
 *
 * Displays feature activity and user/action analysis charts.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Feature Activity -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-admin-settings" style="color: #46b450;"></span>
		<?php _e('Changes by Feature', 'flx-woo'); ?>
	</h2>
	<p class="description"><?php _e('Which feature flags are modified most frequently.', 'flx-woo'); ?></p>

	<div class="flx-chart-container">
		<div class="flx-chart-loading" id="flx-feature-loading">
			<?php _e('Loading chart...', 'flx-woo'); ?>
		</div>
		<canvas id="flx-feature-chart" style="display: none;"></canvas>
	</div>
</div>

<!-- Section: User & Action Charts (Two-column) -->
<div class="flx-dashboard-section">
	<h2>
		<span class="dashicons dashicons-groups" style="color: #f0b849;"></span>
		<?php _e('User & Action Analysis', 'flx-woo'); ?>
	</h2>
	<p class="description"><?php _e('Activity breakdown by user and action type.', 'flx-woo'); ?></p>

	<div class="flx-chart-grid">
		<div class="flx-chart-container">
			<h3><?php _e('Top Users', 'flx-woo'); ?></h3>
			<div class="flx-chart-loading" id="flx-user-loading">
				<?php _e('Loading chart...', 'flx-woo'); ?>
			</div>
			<canvas id="flx-user-chart" style="display: none;"></canvas>
		</div>

		<div class="flx-chart-container">
			<h3><?php _e('Action Distribution', 'flx-woo'); ?></h3>
			<div class="flx-chart-loading" id="flx-action-loading">
				<?php _e('Loading chart...', 'flx-woo'); ?>
			</div>
			<canvas id="flx-action-chart" style="display: none;"></canvas>
		</div>
	</div>
</div>
