<?php
/**
 * Analytics: Activity Data Table
 *
 * Displays filtered activity data in a paginated table.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<!-- Section: Activity Data Table -->
<div class="flx-dashboard-section" id="flx-activity-table-section" style="display: none;">
	<h2>
		<span class="dashicons dashicons-list-view"></span>
		<?php _e('Filtered Activity Data', 'flx-woo'); ?>
	</h2>
	<p class="description">
		<?php _e('Showing filtered results. Use pagination to navigate through entries.', 'flx-woo'); ?>
	</p>

	<div id="flx-activity-table-loading" class="flx-chart-loading">
		<?php _e('Loading data...', 'flx-woo'); ?>
	</div>

	<div id="flx-activity-table-container" style="display: none;">
		<!-- Per-page selector -->
		<div class="flx-table-controls">
			<label for="flx-per-page"><?php _e('Show:', 'flx-woo'); ?></label>
			<select id="flx-per-page">
				<option value="10">10</option>
				<option value="25" selected>25</option>
				<option value="50">50</option>
				<option value="100">100</option>
			</select>
			<span id="flx-table-info"></span>
		</div>

		<!-- Data table -->
		<table class="widefat striped flx-activity-table">
			<thead>
				<tr>
					<th><?php _e('Date/Time', 'flx-woo'); ?></th>
					<th><?php _e('Feature Flag', 'flx-woo'); ?></th>
					<th><?php _e('Action', 'flx-woo'); ?></th>
					<th><?php _e('Old Value', 'flx-woo'); ?></th>
					<th><?php _e('New Value', 'flx-woo'); ?></th>
					<th><?php _e('User', 'flx-woo'); ?></th>
					<th><?php _e('IP Address', 'flx-woo'); ?></th>
				</tr>
			</thead>
			<tbody id="flx-activity-table-body">
				<!-- Data populated via AJAX -->
			</tbody>
		</table>

		<!-- Pagination -->
		<div class="tablenav">
			<div class="tablenav-pages" id="flx-activity-pagination">
				<!-- Pagination populated via AJAX -->
			</div>
		</div>
	</div>

	<div id="flx-activity-table-empty" style="display: none;">
		<p><?php _e('No activity found matching the selected filters.', 'flx-woo'); ?></p>
	</div>
</div>
