<?php
/**
 * Section Header Component
 *
 * Reusable component for consistent section headers with icon and description.
 *
 * @package FlxWoo\Admin\Views\Components
 * @version 2.4.0
 *
 * @var string $section_title Section title text (will be translated)
 * @var string $section_icon Dashicons class (e.g., 'dashicons-dashboard')
 * @var string $section_icon_color Icon color (hex code, default: '#2271b1')
 * @var string $section_description Optional description text (will be translated if provided)
 */

if (!defined('ABSPATH')) {
	exit;
}

// Validate required variables
if (!isset($section_title)) {
	return;
}

// Set defaults
$section_icon = $section_icon ?? '';
$section_icon_color = $section_icon_color ?? '#2271b1';
$section_description = $section_description ?? '';
?>

<h2>
	<?php if (!empty($section_icon)) : ?>
		<span class="dashicons <?php echo esc_attr($section_icon); ?>" style="color: <?php echo esc_attr($section_icon_color); ?>;"></span>
	<?php endif; ?>
	<?php \_e($section_title, 'flx-woo'); ?>
</h2>
<?php if (!empty($section_description)) : ?>
	<p class="description"><?php \_e($section_description, 'flx-woo'); ?></p>
<?php endif; ?>
