<?php
/**
 * Info Grid Component
 *
 * Reusable component for displaying statistics/info grids.
 * Used across multiple admin sections for consistent metric display.
 *
 * @package FlxWoo\Admin\Views\Components
 * @version 2.4.0
 *
 * @var array $grid_items Array of items to display. Each item is an array with:
 *   - 'label' (string, required): Label text (will be translated)
 *   - 'value' (string|int, required): Display value
 *   - 'color' (string, optional): Border-left color (hex code, default: '#dcdcde')
 *   - 'value_color' (string, optional): Text color for value (hex code)
 *   - 'translate_label' (bool, optional): Whether to translate the label (default: true)
 *   - 'translate_value' (bool, optional): Whether to translate the value (default: false)
 */

if (!defined('ABSPATH')) {
	exit;
}

// Validate required variable
if (!isset($grid_items) || !is_array($grid_items)) {
	return;
}
?>

<div class="flx-info-grid">
	<?php foreach ($grid_items as $item) : ?>
		<?php
		// Extract item properties with defaults
		$label = $item['label'] ?? '';
		$value = $item['value'] ?? '';
		$color = $item['color'] ?? '#dcdcde';
		$value_color = $item['value_color'] ?? '';
		$translate_label = $item['translate_label'] ?? true;
		$translate_value = $item['translate_value'] ?? false;

		// Skip empty items
		if (empty($label)) {
			continue;
		}
		?>
		<div class="flx-info-item" style="border-left-color: <?php echo esc_attr($color); ?>;">
			<strong>
				<?php
				if ($translate_label) {
					\_e($label, 'flx-woo');
				} else {
					echo esc_html($label);
				}
				?>
			</strong>
			<span style="font-size: 18px; font-weight: 600;<?php echo $value_color ? ' color: ' . esc_attr($value_color) . ';' : ''; ?>">
				<?php
				if ($translate_value) {
					echo \__($value, 'flx-woo');
				} else {
					echo esc_html($value);
				}
				?>
			</span>
		</div>
	<?php endforeach; ?>
</div>
