<?php
/**
 * Feature Flags Settings Page Template
 *
 * Admin template for managing feature flags.
 * Enhanced UI with dashboard, dependency visualization, and health monitoring.
 *
 * Refactored into modular partials for improved maintainability.
 *
 * @package FlxWoo\Admin
 * @version 2.4.0
 *
 * @var FeatureFlagsPage $this Controller instance
 * @var array $flags Feature flag configurations
 * @var string $store_id Current store ID (hash)
 * @var array $enabled_features Currently enabled feature names
 * @var bool $kill_switch_active Global kill switch status
 */

if (!defined('ABSPATH')) {
	exit;
}

// Get data for partials
$overview = $this->get_feature_overview();
$status_list = $this->get_feature_status_list();
$dependency_tree = $this->get_dependency_tree();
$health = $this->get_feature_health();
$recent_activity = $this->get_recent_activity(10);
$activity_stats = $this->get_activity_stats();

// Documentation URLs
$docs_url = 'https://flxwoo.com/docs/analytics';
$privacy_url = 'https://flxwoo.com/privacy';

?>

<div class="wrap flx-performance-dashboard">
	<h1><?php _e('Feature Flags', 'flx-woo'); ?></h1>
	<p class="description"><?php _e('Manage feature flags with enhanced visibility into dependencies and health status.', 'flx-woo'); ?></p>

	<?php settings_errors('flx_woo_feature_flags'); ?>

	<!-- Kill Switch Warning -->
	<?php if ($kill_switch_active) : ?>
		<div class="notice notice-error">
			<p>
				<strong><?php _e('⚠️ Global Kill Switch Active', 'flx-woo'); ?></strong><br>
				<?php _e('All FlxWoo features are currently disabled. Disable the kill switch below to enable features.', 'flx-woo'); ?>
			</p>
		</div>
	<?php endif; ?>

	<!-- Section 1: Feature Overview Dashboard -->
	<?php include __DIR__ . '/partials/feature-flags/feature-overview.php'; ?>

	<!-- Section 2: Feature Configuration -->
	<?php include __DIR__ . '/partials/feature-flags/feature-configuration-form.php'; ?>

	<!-- Section 3: Feature Health & Dependencies -->
	<?php include __DIR__ . '/partials/feature-flags/feature-health-dependencies.php'; ?>

	<!-- Section 4: Recent Activity -->
	<?php include __DIR__ . '/partials/feature-flags/recent-activity.php'; ?>

	<!-- Section 5: Emergency Controls -->
	<?php include __DIR__ . '/partials/feature-flags/emergency-controls.php'; ?>

	<!-- Section 6: Store Information -->
	<?php include __DIR__ . '/partials/feature-flags/store-information.php'; ?>

	<!-- Section 7: Data Retention Policies -->
	<?php include __DIR__ . '/partials/feature-flags/data-retention-policies.php'; ?>

	<!-- Section 8: Documentation & Help -->
	<?php include __DIR__ . '/partials/feature-flags/documentation-help.php'; ?>
</div>
