<?php
/**
 * Plugin Compatibility Page View
 *
 * @package FlxWoo
 * @version 2.4.0
 * @var array $compatibility_data Array of plugin compatibility data
 * @var CompatibilityPage $this
 */

use FlxWoo\Admin\CompatibilityPage;

// Prevent direct access
if (!defined('ABSPATH')) {
	exit;
}
?>

<div class="wrap flx-woo-compatibility">
	<h1><?php echo esc_html(get_admin_page_title()); ?></h1>

	<?php settings_errors('flx_woo_compatibility'); ?>

	<?php require __DIR__ . '/partials/compatibility/header.php'; ?>

	<div class="flx-woo-compatibility-content" style="margin-top: 20px;">
		<?php if (empty($compatibility_data)): ?>
			<?php require __DIR__ . '/partials/compatibility/empty-state.php'; ?>
		<?php else: ?>
			<?php require __DIR__ . '/partials/compatibility/table.php'; ?>
		<?php endif; ?>
	</div>

	<?php require __DIR__ . '/partials/compatibility/help.php'; ?>
</div>

<?php require __DIR__ . '/partials/compatibility/styles.php'; ?>

<?php require __DIR__ . '/partials/compatibility/scripts.php'; ?>
