<?php
/**
 * Benchmarking Dashboard View Template
 *
 * Displays store performance comparison to industry benchmarks.
 *
 * @package FlxWoo\Admin\Views
 * @since 2.4.0
 *
 * @var array $overview_stats Overview statistics
 * @var array $comparison_data Comparison data for charts
 * @var array $insights AI-generated insights
 * @var array $period_options Available period options
 * @var object $this BenchmarkingPage instance
 */

if (!defined('ABSPATH')) {
	exit;
}

$current_period = isset($_GET['period']) ? intval($_GET['period']) : 30;
?>

<div class="wrap flx-performance-dashboard flx-benchmarking-dashboard">
	<!-- Page Header -->
	<h1><?php esc_html_e('Benchmarking', 'flx-woo'); ?></h1>
	<p class="description">
		<?php esc_html_e('Compare your store performance to industry averages and get actionable insights.', 'flx-woo'); ?>
	</p>

	<?php require __DIR__ . '/partials/benchmarking/period-selector.php'; ?>

	<?php if (!$overview_stats['has_data']): ?>
		<?php require __DIR__ . '/partials/benchmarking/empty-state.php'; ?>
	<?php else: ?>
		<?php require __DIR__ . '/partials/benchmarking/overview-stats.php'; ?>

		<?php require __DIR__ . '/partials/benchmarking/comparison-charts.php'; ?>

		<?php require __DIR__ . '/partials/benchmarking/insights-panel.php'; ?>

		<?php require __DIR__ . '/partials/benchmarking/help.php'; ?>
	<?php endif; ?>

	<?php require __DIR__ . '/partials/benchmarking/loading-overlay.php'; ?>
</div>

<?php require __DIR__ . '/partials/benchmarking/scripts.php'; ?>
