<?php
/**
 * Activity Analytics Page Template
 *
 * Admin template for displaying feature flag activity analytics with charts.
 *
 * @package FlxWoo\Admin
 * @version 2.4.0
 *
 * @var ActivityAnalyticsPage $this
 * @var array $overview_stats Overview statistics
 * @var array $migration_stats Migration status data
 * @var bool $is_empty_state Whether analytics data exists
 */

if (!defined('ABSPATH')) {
	exit;
}

?>

<div class="wrap flx-performance-dashboard">
	<h1><?php _e('Analytics', 'flx-woo'); ?></h1>
	<p class="description"><?php _e('Visualize feature flag activity with interactive charts and insights.', 'flx-woo'); ?></p>

	<?php if (!$migration_stats['table_exists']): ?>
		<?php require __DIR__ . '/partials/analytics/migration-status.php'; ?>
	<?php elseif ($is_empty_state): ?>
		<?php require __DIR__ . '/partials/analytics/empty-state.php'; ?>
	<?php endif; ?>

	<?php require __DIR__ . '/partials/analytics/overview-stats.php'; ?>

	<?php require __DIR__ . '/partials/analytics/filters-form.php'; ?>

	<?php require __DIR__ . '/partials/analytics/activity-table.php'; ?>

	<?php require __DIR__ . '/partials/analytics/charts-timeline.php'; ?>

	<?php require __DIR__ . '/partials/analytics/charts-breakdown.php'; ?>

	<?php require __DIR__ . '/partials/analytics/insights-help.php'; ?>
</div>
