<?php
/**
 * Enable Analytics Tracking Feature Flag
 *
 * Quick script to enable analytics without going through WordPress admin
 *
 * Usage: php enable-analytics.php
 */

// Load WordPress
require_once dirname(__DIR__, 4) . '/wp-load.php';

if (!defined('ABSPATH')) {
	die('WordPress not loaded');
}

// Load FeatureManager
require_once dirname(__DIR__) . '/src/FeatureFlags/FeatureManager.php';

use FlxWoo\FeatureFlags\FeatureManager;

echo "\n";
echo "🔧 FlxWoo Analytics Feature Flag Manager\n";
echo str_repeat('=', 80) . "\n";
echo "\n";

// Get current flags
$flags = get_option(FeatureManager::OPTION_KEY, []);

echo "📊 Current Status:\n";
if (isset($flags[FeatureManager::ANALYTICS_TRACKING])) {
	$analytics = $flags[FeatureManager::ANALYTICS_TRACKING];
	echo "  - Enabled Globally: " . ($analytics['enabled_globally'] ? 'YES' : 'NO') . "\n";
	echo "  - Rollout Percentage: " . ($analytics['rollout_percentage'] ?? 0) . "%\n";
} else {
	echo "  - NOT CONFIGURED (will use defaults: disabled)\n";
}

echo "\n";

// Enable analytics
$flags[FeatureManager::ANALYTICS_TRACKING] = [
	'name' => FeatureManager::ANALYTICS_TRACKING,
	'display_name' => 'Analytics Tracking',
	'description' => 'Track anonymous checkout events for benchmarking (GDPR/CCPA compliant)',
	'enabled_globally' => true,
	'rollout_percentage' => 100,
	'version' => '2.3.0',
	'risky_operation' => false,
	'enabled_stores' => [],
	'disabled_stores' => [],
];

update_option(FeatureManager::OPTION_KEY, $flags);

echo "✅ Analytics tracking ENABLED!\n";
echo "\n";

echo "📋 New Status:\n";
echo "  - Enabled Globally: YES\n";
echo "  - Rollout Percentage: 100%\n";
echo "\n";

echo "🎯 Next Steps:\n";
echo "  1. Visit your checkout page: http://localhost/woo/checkout\n";
echo "  2. Complete a test order\n";
echo "  3. Check events: npx tsx scripts/query-analytics.ts\n";
echo "\n";

echo "✓ Done!\n";
echo "\n";
