<?php
/*
  Plugin Name: FlxWoo
  Plugin URI: https://flxwoo.com
  Description: Headless WooCommerce checkout with FlxWoo — keep all payment gateways, shipping, and coupons working.
  Version: 2.5.0
  Text Domain: flx-woo
  Domain Path: /languages
  Requires Plugins: woocommerce
  Author: Rickey Gu
  Author URI: https://flexplat.com
  License: MIT
  License URI: https://opensource.org/license/mit
*/
if (!defined('ABSPATH')) exit;

require_once __DIR__ . '/src/Bootstrap.php';

// Plugin activation hook
register_activation_hook(__FILE__, function() {
  // Initialize feature flags with defaults
  require_once __DIR__ . '/src/FeatureFlags/FeatureManager.php';
  \FlxWoo\FeatureFlags\FeatureManager::initialize();

  // Create activity log database table and migrate data
  require_once __DIR__ . '/src/Database/Migrator.php';
  \FlxWoo\Database\Migrator::create_table();
  \FlxWoo\Database\Migrator::migrate_from_options();

  // Auto-generate and register analytics API key
  require_once __DIR__ . '/src/Analytics/SiteRegistration.php';
  \FlxWoo\Analytics\SiteRegistration::register_on_activation();
});

add_action('plugins_loaded', function () {
  // Check if WooCommerce is active
  if (!class_exists('WooCommerce')) {
    add_action('admin_notices', function() {
      $message = sprintf(
        '<strong>%s:</strong> %s',
        esc_html__('FlxWoo', 'flx-woo'),
        esc_html__('This plugin requires WooCommerce to be installed and active.', 'flx-woo')
      );
      printf('<div class="error"><p>%s</p></div>', wp_kses_post($message));
    });
    return;
  }

  // Initialize the plugin
  (new \FlxWoo\Bootstrap())->init();
});
