# FlxWoo - WordPress Bridge Plugin

> WordPress plugin component of FlxWoo - Headless WooCommerce checkout powered by Next.js

[![WordPress Plugin Version](https://img.shields.io/badge/wordpress-6.0%2B-blue.svg)](https://wordpress.org/plugins/flx-woo/)
[![WooCommerce](https://img.shields.io/badge/woocommerce-8.0%2B-purple.svg)](https://woocommerce.com/)
[![PHP Version](https://img.shields.io/badge/php-8.0%2B-777BB4.svg)](https://www.php.net/)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](./LICENSE)

## Overview

**FlxWoo** transforms your WooCommerce checkout into a modern, blazing-fast experience powered by Next.js, without breaking any existing functionality. This is the **WordPress plugin component** that bridges WooCommerce with the Next.js rendering engine.

## Architecture

FlxWoo consists of two tightly integrated components:

1. **flx-woo (WordPress Plugin)** - *This repository*
   - WooCommerce data aggregation
   - REST API endpoints
   - Rendering proxy with fallback
   - CORS configuration

2. **flx (Next.js Renderer)** - *Separate repository*
   - HTML generation with custom templates
   - Modern UI with Tailwind CSS 4
   - Server-side rendering

**How it works:** WordPress sends cart data → Next.js renders HTML → WordPress displays custom page

## Installation

### For End Users

Install from WordPress.org (recommended):

1. Log in to WordPress Admin
2. Navigate to **Plugins → Add New**
3. Search for "FlxWoo"
4. Click **Install Now** then **Activate**

### For Developers

```bash
# Clone the repository
cd /path/to/wordpress/wp-content/plugins/
git clone https://github.com/your-org/flx-woo.git
cd flx-woo

# Install dependencies
composer install

# Activate the plugin
wp plugin activate flx-woo
```

## Configuration

### Admin Settings Page (v2.1.0+)

Navigate to: **WordPress Admin > WooCommerce > FlxWoo**

Configure:
- Renderer URL (where to send cart data)
- Request timeout (1-60 seconds)
- Cache settings
- Development mode (allow HTTP for localhost)

### Advanced Configuration

Override settings in `wp-config.php`:

```php
define('FLX_WOO_RENDERER_URL', 'https://your-renderer.com');
define('FLX_WOO_RENDERER_TIMEOUT', 10);
```

**Settings Priority:** Database (Admin UI) > wp-config.php > Default Values

## Features

### v2.4.0 (Current)

- 📈 **Benchmarking Dashboard** - Compare store performance to industry standards
  - Visual performance metrics comparison (conversion rate, AOV, cart abandonment)
  - Interactive charts showing your store vs. industry averages
  - Configurable time periods (7, 30, 90 days)
  - Actionable insights and recommendations based on performance
- 🧪 **A/B Testing** - Test checkout variations and optimize conversions
  - Create and manage checkout A/B tests
  - Real-time test results with statistical significance
  - Winner selection based on statistical confidence
- 🔌 **Plugin Compatibility Database** - Compatibility tracking and reporting
  - View tested plugins and their compatibility status
  - Report compatibility issues directly from admin
  - Crowdsourced compatibility data from FlxWoo community

### v2.3.0

- 🎛️ **Enhanced Feature Flags Management** - Modern dashboard with visual insights
  - Feature Overview Dashboard with at-a-glance statistics
  - Interactive dependency tree visualization
  - Health status monitoring with color-coded indicators
  - Card-based configuration UI with real-time rollout sliders
  - Kill switch confirmation dialog for safety
- 🚩 **Feature Flag System** - Gradual rollout and A/B testing capabilities
- 📊 **Analytics Integration** - Anonymous tracking for optimization

### v2.1.0

- ⚙️ **Admin Settings Page** - Easy configuration via WordPress admin
- 🏥 **Health Dashboard** - Real-time system status monitoring
- 🛡️ **Rate Limiting** - API abuse protection with GDPR compliance
- 📊 **Error Monitoring** - Automatic issue tracking with PII sanitization
- 🔒 **Security** - Enhanced PII protection, validated inputs, secure logging

### Core Features

- REST API endpoints (`/wp-json/flx-woo/v1/`)
- Automatic CORS configuration
- Graceful fallback to native WooCommerce
- PII sanitization for logs
- Zero breaking changes to existing WooCommerce setup

## Documentation

| File | Description |
|------|-------------|
| **[readme.txt](./readme.txt)** | WordPress.org plugin description |
| **[PRIVACY.md](./PRIVACY.md)** | Privacy policy and data handling |
| **[ERROR_LOGGING.md](./ERROR_LOGGING.md)** | Logging and debugging guide |
| **[LICENSE](./LICENSE)** | MIT License |

## Development

### Requirements

- PHP 8.0+
- WordPress 6.0+
- WooCommerce 8.0+
- Composer (for dependencies)

### Running Tests

```bash
# Install test dependencies
composer install --dev

# Run PHPUnit tests
composer test

# Run tests with coverage
composer test:coverage
```

### Code Standards

This plugin follows WordPress coding standards:

```bash
# Check code standards
composer phpcs

# Fix code standards automatically
composer phpcbf
```

## REST API Endpoints

### Site Information
```
GET /wp-json/flx-woo/v1/site-info
```

Returns site metadata (name, currency, locale, etc.)

### Health Check
```
GET /wp-json/flx-woo/v1/health
```

Returns plugin health status

## Support

- **Documentation:** [flxwoo.com/docs](https://flxwoo.com/docs)
- **WordPress Forums:** [wordpress.org/support/plugin/flx-woo](https://wordpress.org/support/plugin/flx-woo/)
- **Issues:** Report bugs on WordPress support forums
- **Email:** rickey29@gmail.com

## Contributing

This plugin is open source under the MIT license. Contributions are welcome!

1. Fork the repository
2. Create a feature branch
3. Commit your changes
4. Push to the branch
5. Create a Pull Request

## Version

**Current Version:** 2.3.0
**Release Date:** December 17, 2024

See [CHANGELOG.md](./CHANGELOG.md) for detailed changelog.

## License

MIT License - see [LICENSE](./LICENSE) file for details.

## Related Projects

- **flx (Next.js Renderer)** - The Next.js rendering component
- **FlxWoo SaaS** - Hosted rendering service

---

**Made with ❤️ by [Rickey Gu](https://flexplat.com)**
